/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.wireless;

import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.SyncProfile;
import at.mrdevelopment.esl.wireless.WakeupProfile;

public enum WakeupProfileMapping {
    DEFAULT{

        @Override
        public WakeupProfile getRealWakeupProfile(WakeupProfile wakeupProfile) {
            return wakeupProfile;
        }
    }
    ,
    SLOWER{

        @Override
        public WakeupProfile getRealWakeupProfile(WakeupProfile wakeupProfile) {
            switch (wakeupProfile) {
                case EIGHTH: {
                    return WakeupProfile.QUARTER;
                }
                case QUARTER: {
                    return WakeupProfile.HALF;
                }
                case HALF: {
                    return WakeupProfile.NORMAL;
                }
                case NORMAL: {
                    return WakeupProfile.DOUBLE;
                }
                case DOUBLE: {
                    return WakeupProfile.QUAD;
                }
                case QUAD: {
                    return WakeupProfile.QUAD;
                }
            }
            throw new AssertionError();
        }
    }
    ,
    FASTER{

        @Override
        public WakeupProfile getRealWakeupProfile(WakeupProfile wakeupProfile) {
            switch (wakeupProfile) {
                case EIGHTH: {
                    return WakeupProfile.EIGHTH;
                }
                case QUARTER: {
                    return WakeupProfile.EIGHTH;
                }
                case HALF: {
                    return WakeupProfile.QUARTER;
                }
                case NORMAL: {
                    return WakeupProfile.HALF;
                }
                case DOUBLE: {
                    return WakeupProfile.NORMAL;
                }
                case QUAD: {
                    return WakeupProfile.DOUBLE;
                }
            }
            throw new AssertionError();
        }
    };


    public abstract WakeupProfile getRealWakeupProfile(WakeupProfile var1);

    public static WakeupProfileMapping forAddress(Address address) {
        return address.isSlowerWakeup() ? SLOWER : DEFAULT;
    }

    public static WakeupProfile forAddress(Address address, SyncProfile syncProfile) {
        if (syncProfile.isSlowerWakeupSupported()) {
            return WakeupProfileMapping.forAddress(address).getRealWakeupProfile(syncProfile.getWakeupProfile());
        }
        return syncProfile.getWakeupProfile();
    }
}

