/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.wireless;

public enum WakeupProfile {
    EIGHTH(31L){

        @Override
        public int getNormalWakeupEqulivalent(int wakeups) {
            return wakeups << 3;
        }
    }
    ,
    QUARTER(63L){

        @Override
        public int getNormalWakeupEqulivalent(int wakeups) {
            return wakeups << 2;
        }
    }
    ,
    HALF(127L){

        @Override
        public int getNormalWakeupEqulivalent(int wakeups) {
            return wakeups << 1;
        }
    }
    ,
    NORMAL(255L){

        @Override
        public int getNormalWakeupEqulivalent(int wakeups) {
            return wakeups;
        }
    }
    ,
    DOUBLE(511L){

        @Override
        public int getNormalWakeupEqulivalent(int wakeups) {
            return wakeups >> 1;
        }
    }
    ,
    QUAD(1023L){

        @Override
        public int getNormalWakeupEqulivalent(int wakeups) {
            return wakeups >> 2;
        }
    };

    private final long mask;
    private final int slotsPerCycle;

    public static void main(String[] args) {
        for (WakeupProfile wakeupProfile : WakeupProfile.values()) {
            System.out.format("name=%-7s mask=%08X slotsPerCycle=%4d wakeupEquivalent=%d%n", wakeupProfile.name(), wakeupProfile.getMask(), wakeupProfile.getSlotsPerCycle(), wakeupProfile.getNormalWakeupEqulivalent(30));
        }
    }

    private WakeupProfile(long mask) {
        this.mask = mask;
        this.slotsPerCycle = (int)mask + 1;
    }

    public long getMask() {
        return this.mask;
    }

    public int getSlotsPerCycle() {
        return this.slotsPerCycle;
    }

    public abstract int getNormalWakeupEqulivalent(int var1);
}

