/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.wireless;

import at.mrdevelopment.esl.wireless.RoamingProfile;
import at.mrdevelopment.esl.wireless.WakeupProfile;
import java.util.HashSet;
import java.util.Set;
import joptsimple.internal.Strings;

public final class SyncProfile
extends Enum<SyncProfile> {
    public static final /* enum */ SyncProfile NORMAL = new SyncProfile(0, WakeupProfile.NORMAL, RoamingProfile.NORMAL, true);
    public static final /* enum */ SyncProfile FAST_ROAMING = new SyncProfile(1, WakeupProfile.NORMAL, RoamingProfile.FAST, true);
    public static final /* enum */ SyncProfile SUPER_FAST_RESPONSE = new SyncProfile(2, WakeupProfile.QUARTER, RoamingProfile.NORMAL);
    public static final /* enum */ SyncProfile ULTRA_FAST_RESPONSE = new SyncProfile(5, WakeupProfile.EIGHTH, RoamingProfile.NORMAL);
    public static final SyncProfile RETAIL_DEFAULT;
    private static final Set<SyncProfile> compatibilityProfiles;
    private final int profileId;
    private final WakeupProfile wakeupProfile;
    private final RoamingProfile roamingProfile;
    private final boolean slowerWakeupSupported;
    private static final /* synthetic */ SyncProfile[] $VALUES;

    public static SyncProfile[] values() {
        return (SyncProfile[])$VALUES.clone();
    }

    public static SyncProfile valueOf(String name) {
        return Enum.valueOf(SyncProfile.class, name);
    }

    public static boolean isCompatibilityProfile(SyncProfile syncProfile) {
        return compatibilityProfiles.contains((Object)syncProfile);
    }

    public static SyncProfile fromString(String syncProfile) {
        if (Strings.isNullOrEmpty((String)syncProfile)) {
            return RETAIL_DEFAULT;
        }
        try {
            return SyncProfile.valueOf(syncProfile);
        }
        catch (IllegalArgumentException exc) {
            return RETAIL_DEFAULT;
        }
    }

    public static SyncProfile fromId(int profileId) {
        for (SyncProfile profile : SyncProfile.values()) {
            if (profile.profileId != profileId) continue;
            return profile;
        }
        return NORMAL;
    }

    private SyncProfile(int profileId, WakeupProfile wakeupProfile, RoamingProfile roamingProfile, boolean slowerWakeupSupported) {
        assert (profileId <= 7);
        this.profileId = profileId;
        this.wakeupProfile = wakeupProfile;
        this.roamingProfile = roamingProfile;
        this.slowerWakeupSupported = slowerWakeupSupported;
    }

    private SyncProfile(int profileId, WakeupProfile wakeupProfile, RoamingProfile roamingProfile) {
        this(profileId, wakeupProfile, roamingProfile, false);
    }

    public int getProfileId() {
        return this.profileId;
    }

    public WakeupProfile getWakeupProfile() {
        return this.wakeupProfile;
    }

    public RoamingProfile getRoamingProfile() {
        return this.roamingProfile;
    }

    public boolean isSlowerWakeupSupported() {
        return this.slowerWakeupSupported;
    }

    static {
        $VALUES = new SyncProfile[]{NORMAL, FAST_ROAMING, SUPER_FAST_RESPONSE, ULTRA_FAST_RESPONSE};
        RETAIL_DEFAULT = NORMAL;
        compatibilityProfiles = new HashSet<SyncProfile>();
        compatibilityProfiles.add(NORMAL);
        compatibilityProfiles.add(FAST_ROAMING);
    }
}

