/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.wireless;

import at.mrdevelopment.esl.wireless.Packet;
import at.mrdevelopment.esl.wireless.PacketListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimplePacketFilter
implements PacketListener {
    private final Set<Class<? extends Packet>> typeFilter = new HashSet<Class<? extends Packet>>();
    private final List<PacketListener> packetListeners = new ArrayList<PacketListener>();

    public void registerPacketListener(PacketListener listener) {
        this.packetListeners.add(listener);
    }

    public void unregisterPacketListener(PacketListener listener) {
        this.packetListeners.remove(listener);
    }

    public boolean isTypeSelected(Class<Packet> type) {
        return this.typeFilter.contains(type);
    }

    public void setTypeFilterSelected(Class<Packet> type, boolean selected) {
        if (selected) {
            this.typeFilter.add(type);
        } else {
            this.typeFilter.remove(type);
        }
    }

    @Override
    public void receivedPacket(Packet packet) {
        if (this.typeFilter.contains(packet.getClass())) {
            for (PacketListener listener : this.packetListeners) {
                listener.receivedPacket(packet);
            }
        }
    }
}

