/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.wireless;

import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.wireless.ChannelTableEntry;
import at.mrdevelopment.esl.wireless.RoamingAssignment;
import at.mrdevelopment.esl.wireless.SyncProfile;
import java.util.Collection;
import java.util.Collections;

public class RoamingTable {
    private final int protocolId;
    private final int validTimeInMinutes;
    private final int pingIntervalInMinutes;
    private final Collection<ChannelTableEntry> channelTable;
    private final Collection<RoamingAssignment> roamingAssignments;
    private final boolean acceptAllLabels;
    private final boolean encryptionRequired;
    private final boolean allowBlacklistedLabels;
    private final Key key;
    private final SyncProfile syncProfile;

    public RoamingTable(int protocolId, int validTimeInMinutes, int pingIntervalInMinutes, Collection<ChannelTableEntry> channelTable, Collection<RoamingAssignment> roamingAssignments, boolean acceptAllLabels, boolean encryptionRequired, boolean allowBlacklistedLabels, Key key, SyncProfile syncProfile) {
        this.protocolId = protocolId;
        this.validTimeInMinutes = validTimeInMinutes;
        this.pingIntervalInMinutes = pingIntervalInMinutes;
        this.channelTable = channelTable;
        this.roamingAssignments = roamingAssignments;
        this.acceptAllLabels = acceptAllLabels;
        this.encryptionRequired = encryptionRequired;
        this.allowBlacklistedLabels = allowBlacklistedLabels;
        this.key = key;
        this.syncProfile = syncProfile;
    }

    public RoamingTable() {
        this(0, 10, 0, Collections.emptyList(), Collections.emptyList(), false, false, false, Key.emptyKey(), SyncProfile.RETAIL_DEFAULT);
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public int getValidTimeInMinutes() {
        return this.validTimeInMinutes;
    }

    public int getPingIntervalInMinutes() {
        return this.pingIntervalInMinutes;
    }

    public Collection<ChannelTableEntry> getChannelTable() {
        return this.channelTable;
    }

    public Collection<RoamingAssignment> getRoamingAssignments() {
        return this.roamingAssignments;
    }

    public int getSize() {
        return this.roamingAssignments.size();
    }

    public boolean isAcceptAllLabels() {
        return this.acceptAllLabels;
    }

    public boolean isEncryptionRequired() {
        return this.encryptionRequired;
    }

    public boolean isAllowBlacklistedLabels() {
        return this.allowBlacklistedLabels;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public SyncProfile getSyncProfile() {
        return this.syncProfile;
    }
}

