/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.wireless;

import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.Sequence;

public class PoolAddressSequence
implements Sequence<Address> {
    private final Address value;

    public PoolAddressSequence(Address value) {
        this.value = value;
    }

    public Address value() {
        return this.value;
    }

    public Sequence<Address> next() {
        long hardwareAddress = this.value.getHardwareAddress();
        long increment = ((hardwareAddress & 0xE0L) >> 5 | (hardwareAddress & 0x1FL) << 3 | hardwareAddress & 0xFFFFFF00L) + 1L;
        long newHardwareAddress = (increment & 7L) << 5 | (increment & 0xF8L) >> 3 | increment & 0xFFFFFF00L;
        Address newAddress = Address.fromId(newHardwareAddress);
        if (!newAddress.isValid()) {
            return new PoolAddressSequence(newAddress).next();
        }
        return new PoolAddressSequence(newAddress);
    }
}

