/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.wireless;

import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.esl.wireless.Ping;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PingXMLSerializer
implements XMLSerializer<Ping> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Element toXML(Document document, Ping ping) {
        Element pingElement = document.createElement("ping");
        pingElement.setAttribute("keys-not-programmed", String.valueOf(ping.areKeysNotProgrammed()));
        if (ping.getCurrentPage() != null) {
            pingElement.setAttribute("page", String.valueOf(ping.getCurrentPage().getPageIndex()));
        }
        pingElement.setAttribute("version", ping.getFirmwareVersion().getVersionString());
        pingElement.setAttribute("label-errors", String.valueOf(ping.getLabelErrors().getErrorCode()));
        pingElement.setAttribute("power-status", ping.getPowerStatus().name());
        pingElement.setAttribute("sync-quality", String.valueOf(ping.getSyncQuality().getSyncQualityValue()));
        pingElement.setAttribute("key-unset", String.valueOf(ping.isKeyUnset()));
        pingElement.setAttribute("time", this.xmlToolkit.formatTime(ping.getTime()));
        return pingElement;
    }

    public Ping parsePing(Element element) {
        boolean keysNotProgrammed = Boolean.valueOf(element.getAttribute("keys-not-programmed"));
        boolean keyUnset = Boolean.valueOf(element.getAttribute("key-unset"));
        Version version = Version.fromString((String)element.getAttribute("version"));
        PowerStatus powerStatus = PowerStatus.fromString(element.getAttribute("power-status"));
        SyncQuality syncQuality = SyncQuality.valueOf(element.getAttribute("sync-quality"));
        LabelErrors labelErrors = LabelErrors.valueOf(element.getAttribute("label-errors"));
        Page page = element.hasAttribute("page") ? Page.valueOf(Integer.valueOf(element.getAttribute("page"))) : null;
        DateTime time = this.xmlToolkit.parseTime(element.getAttribute("time"));
        return new Ping(time, version, syncQuality, keyUnset, keysNotProgrammed, powerStatus, page, labelErrors);
    }
}

