/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.wireless;

import at.mrdevelopment.esl.wireless.Address;
import org.junit.Assert;
import org.junit.Test;

public class AddressTest {
    @Test
    public void broadcastIsNotLabel() {
        Address address = Address.fromId(0xFFFFFFFFL);
        Assert.assertFalse((boolean)address.isLabel());
    }

    @Test
    public void addressWithBroadcastByteIsNotLabel() {
        Address address1 = Address.fromId(2701132031L);
        Address address2 = Address.fromId(2969567487L);
        Address address3 = Address.fromId(2986344703L);
        Address address4 = Address.fromId(0x100000FFL);
        Assert.assertFalse((boolean)address1.isLabel());
        Assert.assertFalse((boolean)address2.isLabel());
        Assert.assertFalse((boolean)address3.isLabel());
        Assert.assertFalse((boolean)address4.isLabel());
    }

    @Test
    public void addressOutOfRangeIsNotLabel() {
        Address address1 = Address.fromId(0L);
        Address address2 = Address.fromId(4886718345L);
        Assert.assertFalse((boolean)address1.isLabel());
        Assert.assertFalse((boolean)address2.isLabel());
    }

    @Test
    public void validLabels() {
        Address address1 = Address.fromId(0x10000001L);
        Address address2 = Address.fromId(268435710L);
        Address address3 = Address.fromId(285212670L);
        Address address4 = Address.fromId(0xFFFFFFFEL);
        Assert.assertTrue((boolean)address1.isLabel());
        Assert.assertTrue((boolean)address2.isLabel());
        Assert.assertTrue((boolean)address3.isLabel());
        Assert.assertTrue((boolean)address4.isLabel());
    }

    @Test
    public void isSlowerWakeup() {
        Address address1 = Address.fromId(3003121665L);
        Address address2 = Address.fromId(0xEFFFFFFEL);
        Address address3 = Address.fromId(0xF0000000L);
        Address address4 = Address.fromId(0xFFFFFFFEL);
        Assert.assertFalse((boolean)address1.isSlowerWakeup());
        Assert.assertFalse((boolean)address2.isSlowerWakeup());
        Assert.assertTrue((boolean)address3.isSlowerWakeup());
        Assert.assertTrue((boolean)address4.isSlowerWakeup());
    }
}

