/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.wireless;

import at.mrdevelopment.esl.wireless.WakeupProfile;

public class Address
implements Comparable<Address> {
    public static final String PATTERN = "[0-9a-fA-F]{8}";
    public static final long BROADCAST_ADDRESS = 0xFFFFFFFFL;
    public static final long UNDEFINED_ADDRESS = 0L;
    public static final long TRANSMITTER_ADDRESS_SPACE_START = 1L;
    public static final long TRANSMITTER_ADDRESS_SPACE_END = 0xFFFFFFEL;
    public static final long LABEL_ADDRESS_SPACE_START = 0x10000000L;
    public static final long LABEL_ADDRESS_SPACE_END = 0xFFFFFFFEL;
    public static final Address BROADCAST = new Address(0xFFFFFFFFL);
    public static final Address UNDEFINED = new Address(0L);
    public static final int HARDWARE_ADDRESS_SIZE = 4;
    private final long hardwareAddress;

    public static Address fromId(long id) {
        return new Address(id);
    }

    public static Address fromSimplicitiAddress(byte[] address) {
        long hardwareAddress = ((long)address[0] & 0xFFL) << 0 | ((long)address[1] & 0xFFL) << 8 | ((long)address[2] & 0xFFL) << 16 | ((long)address[3] & 0xFFL) << 24;
        return hardwareAddress == 0L ? UNDEFINED : new Address(hardwareAddress);
    }

    public static Address fromByteArray(byte[] address) {
        long hardwareAddress = ((long)address[3] & 0xFFL) << 0 | ((long)address[2] & 0xFFL) << 8 | ((long)address[1] & 0xFFL) << 16 | ((long)address[0] & 0xFFL) << 24;
        return hardwareAddress == 0L ? UNDEFINED : new Address(hardwareAddress);
    }

    public static Address fromString(String address) throws NumberFormatException {
        long hardwareAddress = Long.parseLong(address, 16);
        return new Address(hardwareAddress);
    }

    private Address(long hardwareAddress) {
        this.hardwareAddress = hardwareAddress;
    }

    public boolean isBroadcast() {
        return this.hardwareAddress == 0xFFFFFFFFL;
    }

    public boolean isLabel() {
        return !this.isBroadcast() && this.hardwareAddress >= 0x10000000L && this.hardwareAddress <= 0xFFFFFFFEL && this.isValid();
    }

    public boolean isTransmitter() {
        return !this.isBroadcast() && this.hardwareAddress >= 1L && this.hardwareAddress <= 0xFFFFFFEL && this.isValid();
    }

    public boolean isValid() {
        return (this.hardwareAddress & 0xFFL) != 255L;
    }

    public long getHardwareAddress() {
        return this.hardwareAddress;
    }

    public int getAddressExtension() {
        return (int)(this.hardwareAddress & 0xE0L);
    }

    public byte getTypeIdentifier() {
        return (byte)((this.hardwareAddress & 0xFF000000L) >> 24);
    }

    public boolean isSlowerWakeup() {
        return (this.hardwareAddress & 0xF0000000L) >> 28 == 15L;
    }

    public byte[] getSimplicitiAddress() {
        byte[] address = new byte[]{(byte)((this.hardwareAddress & 0xFFL) >> 0), (byte)((this.hardwareAddress & 0xFF00L) >> 8), (byte)((this.hardwareAddress & 0xFF0000L) >> 16), (byte)((this.hardwareAddress & 0xFF000000L) >> 24)};
        return address;
    }

    public byte[] getSimplicitiAddressPart() {
        byte[] address = new byte[]{(byte)((this.hardwareAddress & 0xFF00L) >> 8), (byte)((this.hardwareAddress & 0xFF0000L) >> 16), (byte)((this.hardwareAddress & 0xFF000000L) >> 24)};
        return address;
    }

    public byte[] toByteArray() {
        byte[] address = new byte[4];
        address[3] = (byte)((this.hardwareAddress & 0xFFL) >> 0);
        address[2] = (byte)((this.hardwareAddress & 0xFF00L) >> 8);
        address[1] = (byte)((this.hardwareAddress & 0xFF0000L) >> 16);
        address[0] = (byte)((this.hardwareAddress & 0xFF000000L) >> 24);
        return address;
    }

    public String getIeeeMac() {
        byte[] address = new byte[]{0, 0, (byte)((this.hardwareAddress & 0xFFL) >> 0), (byte)((this.hardwareAddress & 0xFF00L) >> 8), (byte)((this.hardwareAddress & 0xFF0000L) >> 16), (byte)((this.hardwareAddress & 0xFF000000L) >> 24)};
        return String.format("%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]);
    }

    public int hashCode() {
        return (int)this.hardwareAddress;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Address)) {
            return false;
        }
        Address otherAddress = (Address)other;
        return this.hardwareAddress == otherAddress.hardwareAddress;
    }

    @Override
    public int compareTo(Address other) {
        return Long.valueOf(this.hardwareAddress).compareTo(other.hardwareAddress);
    }

    public String toString() {
        return String.format("%08X", this.hardwareAddress);
    }

    public int getSlot() {
        return (int)(this.hardwareAddress & 0x3FFL);
    }

    public int getWakeupSlot(WakeupProfile wakeupProfile) {
        return (int)(this.hardwareAddress & wakeupProfile.getMask());
    }

    public boolean doNonSlotPartsMatch(Address otherAddress, long realWakeupMask) {
        return (this.hardwareAddress & (realWakeupMask ^ 0xFFFFFFFFFFFFFFFFL)) == (otherAddress.hardwareAddress & (realWakeupMask ^ 0xFFFFFFFFFFFFFFFFL));
    }
}

