/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.TransmissionStatistic;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.updatetask.AuxPageUpdateTask;
import at.mrdevelopment.esl.updatetask.BasicLEDDurationFlashingUpdateTask;
import at.mrdevelopment.esl.updatetask.BasicLEDFlashingUpdateTask;
import at.mrdevelopment.esl.updatetask.BasicLEDRepeatCountFlashingUpdateTask;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.updatetask.FirmwareUpdateTask;
import at.mrdevelopment.esl.updatetask.ForceChannelScanUpdateTask;
import at.mrdevelopment.esl.updatetask.GetConfigUpdateTask;
import at.mrdevelopment.esl.updatetask.ImageUpdateTask;
import at.mrdevelopment.esl.updatetask.InitializeUpdateTask;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.LabelKeys;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.esl.updatetask.PingUpdateTask;
import at.mrdevelopment.esl.updatetask.QueryCounterUpdateTask;
import at.mrdevelopment.esl.updatetask.QuerySensorUpdateTask;
import at.mrdevelopment.esl.updatetask.RebootUpdateTask;
import at.mrdevelopment.esl.updatetask.RefreshDisplayUpdateTask;
import at.mrdevelopment.esl.updatetask.ResetAllCountersUpdateTask;
import at.mrdevelopment.esl.updatetask.ResetCounterUpdateTask;
import at.mrdevelopment.esl.updatetask.SetConfigUpdateTask;
import at.mrdevelopment.esl.updatetask.SwitchPageUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.updatetask.UnlockLabelUpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.Ping;
import at.mrdevelopment.esl.wireless.PingXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.image.ImageConversionException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UpdateTaskXMLSerializer
implements XMLSerializer<ExternalUpdateTask> {
    static ESLLogger logger = ESLLogger.getLogger(UpdateTaskXMLSerializer.class);
    private final XMLToolkit xmlToolkit = new XMLToolkit();
    private final PingXMLSerializer pingXMLSerializer = new PingXMLSerializer();

    public Document toXML(ExternalUpdateTask updateTask, boolean includeData) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        document.appendChild(this.updateTaskToXML(document, updateTask, includeData));
        return document;
    }

    public Document toXML(Collection<ExternalUpdateTask> updateTasks, boolean includeData) throws SerializeException {
        return this.toXML(updateTasks, includeData, false);
    }

    public Document toXML(Collection<ExternalUpdateTask> updateTasks, boolean includeData, boolean useOldSerialization) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        Element list = document.createElement("update-tasks");
        for (ExternalUpdateTask updateTask : updateTasks) {
            list.appendChild(this.updateTaskToXML(document, updateTask, includeData, useOldSerialization));
        }
        document.appendChild(list);
        return document;
    }

    public Element updateTaskToXML(Document document, ExternalUpdateTask updateTask, boolean includeData) throws SerializeException {
        return this.updateTaskToXML(document, updateTask, includeData, false);
    }

    public Element updateTaskToXML(Document document, ExternalUpdateTask updateTask, boolean includeData, boolean useOldSerialization) throws SerializeException {
        Element element;
        Element taskElement = document.createElement("update-task");
        taskElement.setAttribute("id", updateTask.getTaskId().toString());
        taskElement.setAttribute("address", updateTask.getAddress().toString());
        taskElement.setAttribute("priority", updateTask.getPriority().toString());
        taskElement.setAttribute("status", updateTask.getStatus().toString());
        if (updateTask.getUpdateError() != null) {
            taskElement.setAttribute("error-code", Integer.toString(updateTask.getUpdateError().getCode()));
        }
        taskElement.setAttribute("revision", Integer.toString(updateTask.getRevision()));
        taskElement.setAttribute("created-at", this.xmlToolkit.formatTime(updateTask.getCreatedAtTime()));
        taskElement.setAttribute("updated-at", this.xmlToolkit.formatTime(updateTask.getUpdatedAtTime()));
        if (updateTask instanceof ImageUpdateTask) {
            ImageUpdateTask imageUpdateTask = (ImageUpdateTask)updateTask;
            element = document.createElement("image");
            if (includeData) {
                element.setAttribute("data", imageUpdateTask.getEncodedData());
            }
            element.setAttribute("page", Integer.toString(imageUpdateTask.getPage().getPageIndex()));
            element.setAttribute("preload", Boolean.toString(imageUpdateTask.isPreload()));
            taskElement.appendChild(element);
        } else if (updateTask instanceof FirmwareUpdateTask) {
            FirmwareUpdateTask firmwareUpdateTask = (FirmwareUpdateTask)updateTask;
            element = document.createElement("firmware");
            if (includeData) {
                element.setAttribute("data", firmwareUpdateTask.getEncodedData());
            }
            taskElement.appendChild(element);
        } else if (updateTask instanceof AuxPageUpdateTask) {
            AuxPageUpdateTask auxPageUpdateTask = (AuxPageUpdateTask)updateTask;
            element = document.createElement("aux-page");
            if (includeData) {
                element.setAttribute("data", auxPageUpdateTask.getEncodedData());
            }
            taskElement.appendChild(element);
        } else if (updateTask instanceof SwitchPageUpdateTask) {
            SwitchPageUpdateTask switchPageUpdateTask = (SwitchPageUpdateTask)updateTask;
            element = document.createElement("switch-page");
            element.setAttribute("page", Integer.toString(switchPageUpdateTask.getPage().getPageIndex()));
            element.setAttribute("durationInMinutes", String.valueOf(switchPageUpdateTask.getDurationInMinutes()));
            taskElement.appendChild(element);
        } else if (updateTask instanceof RefreshDisplayUpdateTask) {
            Element element2 = document.createElement("refresh-display");
            taskElement.appendChild(element2);
        } else if (updateTask instanceof QuerySensorUpdateTask) {
            QuerySensorUpdateTask querySensorUpdateTask = (QuerySensorUpdateTask)updateTask;
            element = document.createElement("query-sensor");
            for (LabelSensor sensor : querySensorUpdateTask.getSensors()) {
                Element sensorElement = document.createElement("sensor");
                Integer sensorValue = querySensorUpdateTask.getSensorValue(sensor);
                if (!useOldSerialization) {
                    sensorElement.setAttribute("id", Integer.toString(sensor.getSensorId()));
                }
                sensorElement.setAttribute("name", sensor.toString());
                if (sensorValue != null) {
                    sensorElement.setAttribute("value", Integer.toString(sensorValue));
                }
                element.appendChild(sensorElement);
            }
            taskElement.appendChild(element);
        } else if (updateTask instanceof SetConfigUpdateTask) {
            SetConfigUpdateTask setConfigUpdateTask = (SetConfigUpdateTask)updateTask;
            element = document.createElement("set-config");
            for (LabelConfig config : setConfigUpdateTask.getConfigs()) {
                Element configElement = document.createElement("config");
                int configValue = setConfigUpdateTask.getConfigValue(config);
                if (!useOldSerialization) {
                    configElement.setAttribute("id", Integer.toString(config.getConfigId()));
                }
                configElement.setAttribute("name", config.toString());
                configElement.setAttribute("value", Integer.toString(configValue));
                element.appendChild(configElement);
            }
            taskElement.appendChild(element);
        } else if (updateTask instanceof GetConfigUpdateTask) {
            GetConfigUpdateTask setConfigUpdateTask = (GetConfigUpdateTask)updateTask;
            element = document.createElement("get-config");
            for (LabelConfig config : setConfigUpdateTask.getConfigs()) {
                Element configElement = document.createElement("config");
                Integer configValue = setConfigUpdateTask.getConfigValue(config);
                if (!useOldSerialization) {
                    configElement.setAttribute("id", Integer.toString(config.getConfigId()));
                }
                configElement.setAttribute("name", config.toString());
                if (configValue != null) {
                    configElement.setAttribute("value", Integer.toString(configValue));
                }
                element.appendChild(configElement);
            }
            taskElement.appendChild(element);
        } else if (updateTask instanceof InitializeUpdateTask) {
            InitializeUpdateTask programKeysUpdateTask = (InitializeUpdateTask)updateTask;
            element = document.createElement("program-keys");
            for (LabelKeys key : programKeysUpdateTask.getKeys()) {
                Element keyElement = document.createElement("key");
                String keyValue = programKeysUpdateTask.getKeyValue(key);
                if (!useOldSerialization) {
                    keyElement.setAttribute("id", Integer.toString(key.getKeyId()));
                }
                keyElement.setAttribute("name", key.toString());
                keyElement.setAttribute("value", keyValue);
                element.appendChild(keyElement);
            }
            taskElement.appendChild(element);
        } else if (updateTask instanceof ResetAllCountersUpdateTask) {
            Element element3 = document.createElement("reset-all-counters");
            taskElement.appendChild(element3);
        } else if (updateTask instanceof ResetCounterUpdateTask) {
            ResetCounterUpdateTask resetCounterUpdateTask = (ResetCounterUpdateTask)updateTask;
            element = document.createElement("reset-counter");
            for (LabelCounter counter : resetCounterUpdateTask.getCounters()) {
                Element counterElement = document.createElement("counter");
                if (!useOldSerialization) {
                    counterElement.setAttribute("id", Integer.toString(counter.getCounterId()));
                }
                counterElement.setAttribute("name", counter.toString());
                element.appendChild(counterElement);
            }
            taskElement.appendChild(element);
        } else if (updateTask instanceof QueryCounterUpdateTask) {
            QueryCounterUpdateTask queryCounterUpdateTask = (QueryCounterUpdateTask)updateTask;
            element = document.createElement("query-counter");
            for (LabelCounter counter : queryCounterUpdateTask.getCounters()) {
                Element counterElement = document.createElement("counter");
                Integer counterValue = queryCounterUpdateTask.getCounterValue(counter);
                if (!useOldSerialization) {
                    counterElement.setAttribute("id", Integer.toString(counter.getCounterId()));
                }
                counterElement.setAttribute("name", counter.toString());
                if (counterValue != null) {
                    counterElement.setAttribute("value", Integer.toString(counterValue));
                }
                element.appendChild(counterElement);
            }
            taskElement.appendChild(element);
        } else if (updateTask instanceof ForceChannelScanUpdateTask) {
            ForceChannelScanUpdateTask forceChannelScanUpdateTask = (ForceChannelScanUpdateTask)updateTask;
            element = document.createElement("force-channel-scan");
            element.setAttribute("all-channels", Boolean.toString(forceChannelScanUpdateTask.isScanAllChannels()));
            taskElement.appendChild(element);
        } else if (updateTask instanceof RebootUpdateTask) {
            Element element4 = document.createElement("reboot");
            taskElement.appendChild(element4);
        } else if (updateTask instanceof PingUpdateTask) {
            Element element5 = document.createElement("ping");
            PingUpdateTask pingTask = (PingUpdateTask)updateTask;
            if (pingTask.hasPingInformation()) {
                Element pingElement = this.pingXMLSerializer.toXML(document, pingTask.getPing());
                element5.appendChild(pingElement);
            }
            taskElement.appendChild(element5);
        } else if (updateTask instanceof UnlockLabelUpdateTask) {
            UnlockLabelUpdateTask unlockUpdateTask = (UnlockLabelUpdateTask)updateTask;
            element = document.createElement("unlock");
            element.setAttribute("puk", unlockUpdateTask.getPuk().toBase64());
            taskElement.appendChild(element);
        } else if (updateTask instanceof BasicLEDFlashingUpdateTask) {
            boolean repeat = updateTask instanceof BasicLEDRepeatCountFlashingUpdateTask;
            BasicLEDFlashingUpdateTask flashingUpdateTask = (BasicLEDFlashingUpdateTask)updateTask;
            Element element6 = document.createElement("basic-led-flashing");
            element6.setAttribute("color", String.valueOf(flashingUpdateTask.getColor()));
            element6.setAttribute("pattern", String.valueOf(flashingUpdateTask.getPattern()));
            element6.setAttribute("period", String.valueOf(flashingUpdateTask.getPeriod()));
            element6.setAttribute("repeat", String.valueOf(repeat));
            taskElement.appendChild(element6);
        }
        if (updateTask.hasTransmissionStatistic()) {
            TransmissionStatistic transmissionStatistic = updateTask.getTransmissionStatistic();
            element = document.createElement("transmission-statistic");
            if (transmissionStatistic.hasFullStatistic()) {
                element.setAttribute("rssi", Integer.toString(transmissionStatistic.getRssi()));
                element.setAttribute("lqi", Integer.toString(transmissionStatistic.getLqi()));
            }
            element.setAttribute("transmission-time", Integer.toString(transmissionStatistic.getTransmissionTime()));
            taskElement.appendChild(element);
        }
        return taskElement;
    }

    public List<ExternalUpdateTask> parseXML(Element root) throws SerializeException {
        NodeList nodes = root.getElementsByTagName("update-task");
        ArrayList<ExternalUpdateTask> updateTasks = new ArrayList<ExternalUpdateTask>(nodes.getLength());
        for (int index = 0; index < nodes.getLength(); ++index) {
            try {
                ExternalUpdateTask updateTask = this.parseUpdateTaskFromXML((Element)nodes.item(index));
                updateTasks.add(updateTask);
                continue;
            }
            catch (RuntimeException exc) {
                throw new SerializeException((Throwable)exc);
            }
            catch (ImageConversionException exc) {
                throw new SerializeException((Throwable)exc);
            }
        }
        return updateTasks;
    }

    public List<ExternalUpdateTask> parseXML(InputStream xmlInputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
        return this.parseXML(root);
    }

    private ExternalUpdateTask parseUpdateTaskFromXML(Element taskElement) throws NumberFormatException, IllegalArgumentException, SerializeException, ImageConversionException {
        UpdateTaskStatus status = UpdateTaskStatus.valueOf(taskElement.getAttribute("status"));
        UpdateError updateError = taskElement.hasAttribute("error-code") ? UpdateError.valueOf(Integer.parseInt(taskElement.getAttribute("error-code"))) : null;
        int revision = Integer.parseInt(taskElement.getAttribute("revision"));
        DateTime createdAtTime = this.xmlToolkit.parseTime(taskElement.getAttribute("created-at"));
        DateTime updatedAtTime = this.xmlToolkit.parseTime(taskElement.getAttribute("updated-at"));
        ExternalUpdateTask updateTask = this.createUpdateTask(taskElement);
        updateTask.setStatus(status);
        updateTask.setUpdateError(updateError);
        updateTask.setRevision(revision);
        updateTask.setCreatedAtTime(createdAtTime);
        updateTask.setUpdatedAtTime(updatedAtTime);
        updateTask.setLocalTime(DateTime.now());
        updateTask.setTransmissionStatistic(this.parseTransmissionStatistic(taskElement));
        return updateTask;
    }

    private ExternalUpdateTask createUpdateTask(Element taskElement) throws SerializeException, ImageConversionException {
        UUID taskId = UUID.fromString(taskElement.getAttribute("id"));
        Address address = Address.fromString(taskElement.getAttribute("address"));
        TaskPriority priority = TaskPriority.valueOf(taskElement.getAttribute("priority"));
        NodeList imageNodes = taskElement.getElementsByTagName("image");
        NodeList firmwareNodes = taskElement.getElementsByTagName("firmware");
        NodeList switchPageNodes = taskElement.getElementsByTagName("switch-page");
        NodeList refreshDisplayNodes = taskElement.getElementsByTagName("refresh-display");
        NodeList querySensorNodes = taskElement.getElementsByTagName("query-sensor");
        NodeList setConfigNodes = taskElement.getElementsByTagName("set-config");
        NodeList getConfigNodes = taskElement.getElementsByTagName("get-config");
        NodeList programKeysNodes = taskElement.getElementsByTagName("program-keys");
        NodeList resetAllCountersNodes = taskElement.getElementsByTagName("reset-all-counters");
        NodeList resetCounterNodes = taskElement.getElementsByTagName("reset-counter");
        NodeList queryCounterNodes = taskElement.getElementsByTagName("query-counter");
        NodeList forceChannelScanNodes = taskElement.getElementsByTagName("force-channel-scan");
        NodeList resetHardwareNodes = taskElement.getElementsByTagName("reboot");
        NodeList pingNodes = taskElement.getElementsByTagName("ping");
        NodeList unlockNodes = taskElement.getElementsByTagName("unlock");
        NodeList auxPageNodes = taskElement.getElementsByTagName("aux-page");
        NodeList basicFlashingNodes = taskElement.getElementsByTagName("basic-led-flashing");
        if (imageNodes.getLength() > 0) {
            Element imageElement = (Element)imageNodes.item(0);
            String encodedData = imageElement.hasAttribute("data") ? imageElement.getAttribute("data") : null;
            Page page = Page.fromString(imageElement.getAttribute("page"));
            boolean preload = Boolean.parseBoolean(imageElement.getAttribute("preload"));
            return new ImageUpdateTask(taskId, address, priority, encodedData, page, preload);
        }
        if (firmwareNodes.getLength() > 0) {
            Element firmwareElement = (Element)firmwareNodes.item(0);
            String encodedData = firmwareElement.hasAttribute("data") ? firmwareElement.getAttribute("data") : null;
            return new FirmwareUpdateTask(taskId, address, priority, encodedData);
        }
        if (auxPageNodes.getLength() > 0) {
            Element auxPageElement = (Element)auxPageNodes.item(0);
            String encodedData = auxPageElement.hasAttribute("data") ? auxPageElement.getAttribute("data") : null;
            return new AuxPageUpdateTask(taskId, address, priority, encodedData);
        }
        if (switchPageNodes.getLength() > 0) {
            Element switchPageElement = (Element)switchPageNodes.item(0);
            Page page = Page.fromString(switchPageElement.getAttribute("page"));
            int duration = switchPageElement.hasAttribute("durationInMinutes") ? Integer.valueOf(switchPageElement.getAttribute("durationInMinutes")) : 0;
            return new SwitchPageUpdateTask(taskId, address, priority, page, duration);
        }
        if (refreshDisplayNodes.getLength() > 0) {
            return new RefreshDisplayUpdateTask(taskId, address, priority);
        }
        if (querySensorNodes.getLength() > 0) {
            Element querySensorElement = (Element)querySensorNodes.item(0);
            QuerySensorUpdateTask updateTask = new QuerySensorUpdateTask(taskId, address, priority);
            NodeList sensorNodes = querySensorElement.getElementsByTagName("sensor");
            for (int index = 0; index < sensorNodes.getLength(); ++index) {
                Element sensorElement = (Element)sensorNodes.item(index);
                LabelSensor sensor = sensorElement.hasAttribute("id") ? LabelSensor.fromId(Integer.parseInt(sensorElement.getAttribute("id"))) : LabelSensor.valueOf(sensorElement.getAttribute("name"));
                Integer value = sensorElement.hasAttribute("value") ? Integer.valueOf(Integer.parseInt(sensorElement.getAttribute("value"))) : null;
                updateTask.addSensor(sensor, value);
            }
            return updateTask;
        }
        if (setConfigNodes.getLength() > 0) {
            Element setConfigElement = (Element)setConfigNodes.item(0);
            SetConfigUpdateTask updateTask = new SetConfigUpdateTask(taskId, address, priority);
            NodeList configNodes = setConfigElement.getElementsByTagName("config");
            for (int index = 0; index < configNodes.getLength(); ++index) {
                Element configElement = (Element)configNodes.item(index);
                LabelConfig config = configElement.hasAttribute("id") ? LabelConfig.fromId(Integer.parseInt(configElement.getAttribute("id"))) : LabelConfig.valueOf(configElement.getAttribute("name"));
                int value = Integer.parseInt(configElement.getAttribute("value"));
                updateTask.addConfig(config, value);
            }
            return updateTask;
        }
        if (getConfigNodes.getLength() > 0) {
            Element getConfigElement = (Element)getConfigNodes.item(0);
            GetConfigUpdateTask updateTask = new GetConfigUpdateTask(taskId, address, priority);
            NodeList configNodes = getConfigElement.getElementsByTagName("config");
            for (int index = 0; index < configNodes.getLength(); ++index) {
                Element configElement = (Element)configNodes.item(index);
                LabelConfig config = configElement.hasAttribute("id") ? LabelConfig.fromId(Integer.parseInt(configElement.getAttribute("id"))) : LabelConfig.valueOf(configElement.getAttribute("name"));
                Integer value = configElement.hasAttribute("value") ? Integer.valueOf(Integer.parseInt(configElement.getAttribute("value"))) : null;
                updateTask.addConfig(config, value);
            }
            return updateTask;
        }
        if (programKeysNodes.getLength() > 0) {
            Element programKeysElement = (Element)programKeysNodes.item(0);
            InitializeUpdateTask updateTask = new InitializeUpdateTask(taskId, address, priority);
            NodeList keyNodes = programKeysElement.getElementsByTagName("key");
            for (int index = 0; index < keyNodes.getLength(); ++index) {
                Element keyElement = (Element)keyNodes.item(index);
                LabelKeys key = keyElement.hasAttribute("id") ? LabelKeys.fromId(Integer.parseInt(keyElement.getAttribute("id"))) : LabelKeys.valueOf(keyElement.getAttribute("name"));
                String value = keyElement.getAttribute("value");
                updateTask.addKey(key, value);
            }
            return updateTask;
        }
        if (resetAllCountersNodes.getLength() > 0) {
            return new ResetAllCountersUpdateTask(taskId, address, priority);
        }
        if (resetCounterNodes.getLength() > 0) {
            Element resetCounterElemnt = (Element)resetCounterNodes.item(0);
            ResetCounterUpdateTask updateTask = new ResetCounterUpdateTask(taskId, address, priority);
            NodeList counterNodes = resetCounterElemnt.getElementsByTagName("counter");
            for (int index = 0; index < counterNodes.getLength(); ++index) {
                Element counterElement = (Element)counterNodes.item(index);
                LabelCounter counter = counterElement.hasAttribute("id") ? LabelCounter.fromId(Integer.parseInt(counterElement.getAttribute("id"))) : LabelCounter.valueOf(counterElement.getAttribute("name"));
                updateTask.addCounter(counter);
            }
            return updateTask;
        }
        if (queryCounterNodes.getLength() > 0) {
            Element queryCounterElement = (Element)queryCounterNodes.item(0);
            QueryCounterUpdateTask updateTask = new QueryCounterUpdateTask(taskId, address, priority);
            NodeList counterNodes = queryCounterElement.getElementsByTagName("counter");
            for (int index = 0; index < counterNodes.getLength(); ++index) {
                Element counterElement = (Element)counterNodes.item(index);
                LabelCounter counter = counterElement.hasAttribute("id") ? LabelCounter.fromId(Integer.parseInt(counterElement.getAttribute("id"))) : LabelCounter.valueOf(counterElement.getAttribute("name"));
                Integer value = counterElement.hasAttribute("value") ? Integer.valueOf(Integer.parseInt(counterElement.getAttribute("value"))) : null;
                updateTask.addCounter(counter, value);
            }
            return updateTask;
        }
        if (forceChannelScanNodes.getLength() > 0) {
            Element forceChannelScanElement = (Element)forceChannelScanNodes.item(0);
            boolean scanAllChannels = Boolean.parseBoolean(forceChannelScanElement.getAttribute("all-channels"));
            return new ForceChannelScanUpdateTask(taskId, address, priority, scanAllChannels);
        }
        if (resetHardwareNodes.getLength() > 0) {
            return new RebootUpdateTask(taskId, address, priority);
        }
        if (pingNodes.getLength() > 0) {
            PingUpdateTask updateTask = new PingUpdateTask(taskId, address, priority);
            Element pingTaskElement = (Element)pingNodes.item(0);
            NodeList pingNodeList = pingTaskElement.getElementsByTagName("ping");
            if (pingNodeList.getLength() > 0) {
                Ping ping = this.pingXMLSerializer.parsePing((Element)pingNodeList.item(0));
                updateTask.setPing(ping);
            }
            return updateTask;
        }
        if (unlockNodes.getLength() > 0) {
            Element unlockElement = (Element)unlockNodes.item(0);
            Puk puk = Puk.fromBase64(unlockElement.getAttribute("puk"));
            return new UnlockLabelUpdateTask(taskId, address, priority, puk);
        }
        if (basicFlashingNodes.getLength() > 0) {
            Element flashingElement = (Element)basicFlashingNodes.item(0);
            int color = Integer.parseInt(flashingElement.getAttribute("color"));
            int pattern = Integer.parseInt(flashingElement.getAttribute("pattern"));
            int period = Integer.parseInt(flashingElement.getAttribute("period"));
            boolean repeat = Boolean.valueOf(flashingElement.getAttribute("repeat"));
            return repeat ? new BasicLEDRepeatCountFlashingUpdateTask(taskId, address, priority, color, pattern, period) : new BasicLEDDurationFlashingUpdateTask(taskId, address, priority, color, pattern, period);
        }
        throw new SerializeException("Unknown/missing task content at task %s", new Object[]{taskId});
    }

    private TransmissionStatistic parseTransmissionStatistic(Element taskElement) {
        NodeList transmissionStatisticNodes = taskElement.getElementsByTagName("transmission-statistic");
        if (transmissionStatisticNodes.getLength() > 0) {
            Element element = (Element)transmissionStatisticNodes.item(0);
            int transmissionTime = Integer.parseInt(element.getAttribute("transmission-time"));
            if (element.hasAttribute("rssi") && element.hasAttribute("lqi")) {
                int rssi = Integer.parseInt(element.getAttribute("rssi"));
                int lqi = Integer.parseInt(element.getAttribute("lqi"));
                return TransmissionStatistic.full(rssi, lqi, transmissionTime);
            }
            return TransmissionStatistic.timeOnly(transmissionTime);
        }
        return null;
    }

    public Document newDocument() {
        return this.xmlToolkit.newDocument();
    }
}

