/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.TransmissionStatistic;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.updatetask.AuxPageUpdateTask;
import at.mrdevelopment.esl.updatetask.BasicLEDDurationFlashingUpdateTask;
import at.mrdevelopment.esl.updatetask.BasicLEDRepeatCountFlashingUpdateTask;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.updatetask.FirmwareUpdateTask;
import at.mrdevelopment.esl.updatetask.ForceChannelScanUpdateTask;
import at.mrdevelopment.esl.updatetask.GetConfigUpdateTask;
import at.mrdevelopment.esl.updatetask.ImageUpdateTask;
import at.mrdevelopment.esl.updatetask.InitializeUpdateTask;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.LabelKeys;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.esl.updatetask.PingUpdateTask;
import at.mrdevelopment.esl.updatetask.QueryCounterUpdateTask;
import at.mrdevelopment.esl.updatetask.QuerySensorUpdateTask;
import at.mrdevelopment.esl.updatetask.RebootUpdateTask;
import at.mrdevelopment.esl.updatetask.RefreshDisplayUpdateTask;
import at.mrdevelopment.esl.updatetask.ResetAllCountersUpdateTask;
import at.mrdevelopment.esl.updatetask.ResetCounterUpdateTask;
import at.mrdevelopment.esl.updatetask.SetConfigUpdateTask;
import at.mrdevelopment.esl.updatetask.SwitchPageUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.updatetask.UnlockLabelUpdateTask;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import at.mrdevelopment.toolkit.xml.sax.AbstractSAXContentHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class UpdateTaskContentHandler
extends AbstractSAXContentHandler<List<ExternalUpdateTask>> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();
    private UpdateTaskStatus status;
    private UpdateError updateError;
    private int revision;
    private DateTime createdAtTime;
    private DateTime updatedAtTime;
    private UUID taskId;
    private Address address;
    private TaskPriority priority;
    private ExternalUpdateTask updateTask;

    public void setDocumentLocator(Locator locator) {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equals("update-tasks")) {
            this.result = new ArrayList();
        } else if (localName.equals("update-task")) {
            this.status = UpdateTaskStatus.valueOf(atts.getValue("status"));
            this.updateError = atts.getValue("error-code") != null ? UpdateError.valueOf(Integer.parseInt(atts.getValue("error-code"))) : null;
            this.revision = Integer.parseInt(atts.getValue("revision"));
            this.createdAtTime = this.xmlToolkit.parseTime(atts.getValue("created-at"));
            this.updatedAtTime = this.xmlToolkit.parseTime(atts.getValue("updated-at"));
            this.taskId = UUID.fromString(atts.getValue("id"));
            this.address = Address.fromString(atts.getValue("address"));
            this.priority = TaskPriority.valueOf(atts.getValue("priority"));
        } else if (localName.equals("image")) {
            String encodedData = atts.getValue("data") != null ? atts.getValue("data") : null;
            Page page = Page.fromString(atts.getValue("page"));
            boolean preload = Boolean.parseBoolean(atts.getValue("preload"));
            try {
                this.updateTask = new ImageUpdateTask(this.taskId, this.address, this.priority, encodedData, page, preload);
            }
            catch (SerializeException exc) {
                throw new SAXException((Exception)((Object)exc));
            }
        } else if (localName.equals("firmware")) {
            String encodedData = atts.getValue("data") != null ? atts.getValue("data") : null;
            this.updateTask = new FirmwareUpdateTask(this.taskId, this.address, this.priority, encodedData);
        } else if (localName.equals("aux-page")) {
            String encodedData = atts.getValue("data") != null ? atts.getValue("data") : null;
            this.updateTask = new AuxPageUpdateTask(this.taskId, this.address, this.priority, encodedData);
        } else if (localName.equals("switch-page")) {
            Page page = Page.fromString(atts.getValue("page"));
            int duration = atts.getValue("durationInMinutes") != null ? Integer.valueOf(atts.getValue("durationInMinutes")) : 0;
            this.updateTask = new SwitchPageUpdateTask(this.taskId, this.address, this.priority, page, duration);
        } else if (localName.equals("refresh-display")) {
            this.updateTask = new RefreshDisplayUpdateTask(this.taskId, this.address, this.priority);
        } else if (localName.equals("query-sensor")) {
            this.updateTask = new QuerySensorUpdateTask(this.taskId, this.address, this.priority);
        } else if (localName.equals("sensor")) {
            Integer value;
            String sensorId = atts.getValue("id");
            LabelSensor sensor = sensorId != null ? LabelSensor.fromId(Integer.parseInt(sensorId)) : LabelSensor.valueOf(atts.getValue("name"));
            Integer n = value = atts.getValue("value") != null ? Integer.valueOf(Integer.parseInt(atts.getValue("value"))) : null;
            if (this.updateTask instanceof QuerySensorUpdateTask) {
                ((QuerySensorUpdateTask)this.updateTask).addSensor(sensor, value);
            }
        } else if (localName.equals("set-config")) {
            this.updateTask = new SetConfigUpdateTask(this.taskId, this.address, this.priority);
        } else if (localName.equals("get-config")) {
            this.updateTask = new GetConfigUpdateTask(this.taskId, this.address, this.priority);
        } else if (localName.equals("config")) {
            Integer value;
            String configId = atts.getValue("id");
            LabelConfig config = configId != null ? LabelConfig.fromId(Integer.parseInt(configId)) : LabelConfig.valueOf(atts.getValue("name"));
            Integer n = value = atts.getValue("value") != null ? Integer.valueOf(Integer.parseInt(atts.getValue("value"))) : null;
            if (this.updateTask instanceof GetConfigUpdateTask) {
                ((GetConfigUpdateTask)this.updateTask).addConfig(config, value);
            } else if (this.updateTask instanceof SetConfigUpdateTask) {
                ((SetConfigUpdateTask)this.updateTask).addConfig(config, value);
            }
        } else if (localName.equals("program-keys")) {
            this.updateTask = new InitializeUpdateTask(this.taskId, this.address, this.priority);
        } else if (localName.equals("key")) {
            String value;
            String keyId = atts.getValue("id");
            LabelKeys key = keyId != null ? LabelKeys.fromId(Integer.parseInt(keyId)) : LabelKeys.valueOf(atts.getValue("name"));
            String string = value = atts.getValue("value") != null ? atts.getValue("value") : null;
            if (this.updateTask instanceof InitializeUpdateTask) {
                ((InitializeUpdateTask)this.updateTask).addKey(key, value);
            }
        } else if (localName.equals("reset-all-counters")) {
            this.updateTask = new ResetAllCountersUpdateTask(this.taskId, this.address, this.priority);
        } else if (localName.equals("reset-counter")) {
            this.updateTask = new ResetCounterUpdateTask(this.taskId, this.address, this.priority);
        } else if (localName.equals("query-counter")) {
            this.updateTask = new QueryCounterUpdateTask(this.taskId, this.address, this.priority);
        } else if (localName.equals("counter")) {
            String counterId = atts.getValue("id");
            LabelCounter counter = counterId != null ? LabelCounter.fromId(Integer.parseInt(counterId)) : LabelCounter.valueOf(atts.getValue("name"));
            if (this.updateTask instanceof ResetCounterUpdateTask) {
                ((ResetCounterUpdateTask)this.updateTask).addCounter(counter);
            } else if (this.updateTask instanceof QueryCounterUpdateTask) {
                Integer value = atts.getValue("value") != null ? Integer.valueOf(Integer.parseInt(atts.getValue("value"))) : null;
                ((QueryCounterUpdateTask)this.updateTask).addCounter(counter, value);
            }
        } else if (localName.equals("force-channel-scan")) {
            boolean scanAllChannels = Boolean.parseBoolean(atts.getValue("all-channels"));
            this.updateTask = new ForceChannelScanUpdateTask(this.taskId, this.address, this.priority, scanAllChannels);
        } else if (localName.equals("reboot")) {
            this.updateTask = new RebootUpdateTask(this.taskId, this.address, this.priority);
        } else if (localName.equals("ping")) {
            this.updateTask = new PingUpdateTask(this.taskId, this.address, this.priority);
        } else if (localName.equals("transmission-statistic") && this.updateTask != null) {
            int transmissionTime = Integer.parseInt(atts.getValue("transmission-time"));
            if (atts.getValue("rssi") != null && atts.getValue("lqi") != null) {
                int rssi = Integer.parseInt(atts.getValue("rssi"));
                int lqi = Integer.parseInt(atts.getValue("lqi"));
                this.updateTask.setTransmissionStatistic(TransmissionStatistic.full(rssi, lqi, transmissionTime));
            } else {
                this.updateTask.setTransmissionStatistic(TransmissionStatistic.timeOnly(transmissionTime));
            }
        } else if (localName.equals("unlock")) {
            Puk puk = Puk.fromBase64(atts.getValue("puk"));
            this.updateTask = new UnlockLabelUpdateTask(this.taskId, this.address, this.priority, puk);
        } else if (localName.equals("basic-led-flashing")) {
            int color = Integer.parseInt(atts.getValue("color"));
            int pattern = Integer.parseInt(atts.getValue("pattern"));
            int period = Integer.parseInt(atts.getValue("period"));
            boolean repeat = Boolean.valueOf(atts.getValue("repeat"));
            this.updateTask = repeat ? new BasicLEDRepeatCountFlashingUpdateTask(this.taskId, this.address, this.priority, color, pattern, period) : new BasicLEDDurationFlashingUpdateTask(this.taskId, this.address, this.priority, color, pattern, period);
        }
    }

    private void clearValues() {
        this.status = null;
        this.updateError = null;
        this.revision = -1;
        this.createdAtTime = null;
        this.updatedAtTime = null;
        this.taskId = null;
        this.address = null;
        this.priority = null;
        this.updateTask = null;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("update-task") && this.updateTask != null) {
            this.updateTask.setStatus(this.status);
            this.updateTask.setUpdateError(this.updateError);
            this.updateTask.setRevision(this.revision);
            this.updateTask.setCreatedAtTime(this.createdAtTime);
            this.updateTask.setUpdatedAtTime(this.updatedAtTime);
            this.updateTask.setLocalTime(DateTime.now());
            ((List)this.result).add(this.updateTask);
            this.clearValues();
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void onStartDocument() {
    }
}

