/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

public enum TaskPriority {
    PING(0, "Reserved for ping tasks"),
    LOW(1, "Low priority (task only processed if no higher priority tasks are scheduled)"),
    NORMAL(2, "Normal priority (normal task processing)"),
    HIGH(3, "High priorty (task processing is prefered to lower priority tasks)"),
    JOIN(4, "Reserved for networkin joining");

    public static TaskPriority DEFAULT;
    private final int priorityCode;
    private final String description;

    private TaskPriority(int priorityCode, String description) {
        this.priorityCode = priorityCode;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public boolean isHigh() {
        return this == HIGH;
    }

    public boolean isNormal() {
        return this == NORMAL;
    }

    public boolean isLow() {
        return this == LOW;
    }

    public int getPriorityCode() {
        return this.priorityCode;
    }

    public static TaskPriority valueOf(int priorityCode) {
        for (TaskPriority priority : TaskPriority.values()) {
            if (priority.priorityCode != priorityCode) continue;
            return priority;
        }
        throw new IllegalArgumentException(String.format("Illegal priority code %d", priorityCode));
    }

    static {
        DEFAULT = NORMAL;
    }
}

