/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.updatetask.InternalDataUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.InternalUpdateTaskCommit;
import org.joda.time.DateTime;

public class SetKeyUpdateTask
extends InternalDataUpdateTask {
    private final Pin pin;
    private final Key communicationKey;

    public SetKeyUpdateTask(Address address, Pin pin, Key communicationKey) {
        this(address, pin, communicationKey, 5);
    }

    private SetKeyUpdateTask(Address address, Pin pin, Key communicationKey, int retriesLeft) {
        super(address, TaskPriority.NORMAL, retriesLeft);
        this.pin = pin;
        this.communicationKey = communicationKey;
    }

    public Pin getPin() {
        return this.pin;
    }

    public Key getCommunicationKey() {
        return this.communicationKey;
    }

    @Override
    public SetKeyUpdateTask createRetry() {
        return new SetKeyUpdateTask(this.getAddress(), this.pin, this.communicationKey, Math.max(0, this.getRetriesLeft() - 1));
    }

    @Override
    public void taskCommitted(InternalUpdateTaskCommit commit, DateTime now) {
        commit.setKeyCommitted(this.getAddress(), now);
    }

    @Override
    public void taskFailed(InternalUpdateTaskCommit commit, DateTime now) {
        commit.setKeyFailed(this.getAddress(), now);
    }
}

