/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.updatetask.ExternalCommandUpdateTask;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class QuerySensorUpdateTask
extends ExternalCommandUpdateTask {
    private final ArrayList<LabelSensor> sensors = new ArrayList();
    private final ArrayList<Integer> rawValues = new ArrayList();

    public QuerySensorUpdateTask(UUID taskId, Address address, TaskPriority priority, Collection<LabelSensor> sensors) {
        super(taskId, address, priority);
        for (LabelSensor sensor : sensors) {
            this.addSensor(sensor, null);
        }
    }

    public QuerySensorUpdateTask(UUID taskId, Address address, TaskPriority priority) {
        super(taskId, address, priority);
    }

    public List<LabelSensor> getSensors() {
        return Collections.unmodifiableList(this.sensors);
    }

    public int getSensorCount() {
        return this.sensors.size();
    }

    public void addSensor(LabelSensor sensor, Integer rawValue) {
        int index = this.sensors.size();
        this.sensors.add(index, sensor);
        this.rawValues.add(index, rawValue);
    }

    public Integer getSensorValue(LabelSensor sensor) {
        int index = this.sensors.indexOf((Object)sensor);
        return this.rawValues.get(index);
    }

    public void setSensorValue(LabelSensor sensor, int rawValue) {
        int index = this.sensors.indexOf((Object)sensor);
        this.rawValues.set(index, rawValue);
    }
}

