/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.updatetask.ExternalCommandUpdateTask;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class QueryCounterUpdateTask
extends ExternalCommandUpdateTask {
    private final ArrayList<LabelCounter> counters = new ArrayList();
    private final ArrayList<Integer> values = new ArrayList();

    public QueryCounterUpdateTask(UUID taskId, Address address, TaskPriority priority, Collection<LabelCounter> counters) {
        super(taskId, address, priority);
        for (LabelCounter counter : counters) {
            this.addCounter(counter, null);
        }
    }

    public QueryCounterUpdateTask(UUID taskId, Address address, TaskPriority priority) {
        super(taskId, address, priority);
    }

    public List<LabelCounter> getCounters() {
        return Collections.unmodifiableList(this.counters);
    }

    public int getSensorCount() {
        return this.counters.size();
    }

    public void addCounter(LabelCounter counter, Integer value) {
        int index = this.counters.size();
        this.counters.add(index, counter);
        this.values.add(index, value);
    }

    public Integer getCounterValue(LabelCounter counter) {
        int index = this.counters.indexOf((Object)counter);
        return this.values.get(index);
    }

    public void setCounterValue(LabelCounter counter, int value) {
        int index = this.counters.indexOf((Object)counter);
        this.values.set(index, value);
    }
}

