/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import java.util.HashMap;
import java.util.Map;

public enum LabelCounter {
    BROWNOUT_RESETS(0, "Brownout resets", 10),
    WATCHDOG_RESETS(1, "Watchdog resets", 10),
    EXTERNAL_RESETS(2, "External resets", 10),
    RECEIVED_DATA_PACKETS_MSB(3, "Received packets"),
    RECEIVED_DATA_PACKETS_LSB(4, "Received packets"),
    SUCCESSFUL_TRANSMISSIONS(5, "Successful transmissions", 14600),
    FAILED_TRANSMISSIONS(6, "Failed transmissions"),
    SCANNED_CHANNELS_MSB(7, "Scanned channels MSB"),
    SCANNED_CHANNELS_LSB(8, "Scanned channels LSB"),
    RESYNCS_MSB(9, "Resyncs MSB"),
    RESYNCS_LSB(10, "Resyncs LSB"),
    TOTAL_DISPLAY_UPDATES(11, "Total updates", 7300),
    LOW_TEMP_DIPLAY_UPDATES(12, "Low temp updates", 2),
    HIGH_TEMP_DISPLAY_UPDATES(13, "High temp updates", 2),
    DISPLAY_UPDATES_TEMPFACTOR_1(14, "Temp 1 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_2(15, "Temp 2 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_3(16, "Temp 3 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_4(17, "Temp 4 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_7(18, "Temp 7 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_12(19, "Temp 12 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_17(20, "Temp 17 updates"),
    FAILED_DISPLAY_UPDATES(21, "Failed updates", 0),
    FLASH_INTEGRITY_FAILS(22, "Flash errors", 0),
    RUN_TIME_HOURS(23, "Run time hours", 43800),
    COUNTER_BQ_RESETS(24, "BQ resets", 5),
    DISPLAY_UPDATES_TEMPFACTOR_8(25, "Temp 8 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_9(26, "Temp 9 updates"),
    COUNTER_ERASE_COUNT_RX_BUFFER_LSB(27, "Erase count RX buffer LSB"),
    COUNTER_ERASE_COUNT_DISPLAYED_IMAGE_LSB(28, "Erase count displayed image LSB"),
    DISPLAY_UPDATES_TEMPFACTOR_5(29, "Temp 5 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_6(30, "Temp 6 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_10(31, "Temp 10 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_11(32, "Temp 11 updates"),
    JOIN_REQUESTS_MSB(33, "Join requests MSB"),
    JOIN_REQUESTS_LSB(34, "Join requests LSB"),
    COUNTER_SYNC_RECEIVER_ACTIVE_MS_MSB(35, "RX on ms MSB"),
    COUNTER_SYNC_RECEIVER_ACTIVE_MS_LSB(36, "RX on ms LSB"),
    COUNTER_RECEIVER_ACTIVE_FRAMES_MSB(37, "RX on frames MSB"),
    COUNTER_RECEIVER_ACTIVE_FRAMES_LSB(38, "RX on frames LSB"),
    COUNTER_OFFLINE_TIME_SLOTS_MSB(39, "Offline timeslots MSB"),
    COUNTER_OFFLINE_TIME_SLOTS_LSB(40, "Offline timeslots LSB"),
    COUNTER_HIBERNATE_TIME_SLOTS_MSB(41, "Hibernate timeslots MSB"),
    COUNTER_HIBERNATE_TIME_SLOTS_LSB(42, "Hibernate timeslots LSB"),
    COUNTER_ERASE_COUNT_RX_BUFFER_MSB(43, "Erase count RX buffer MSB"),
    COUNTER_ERASE_COUNT_DISPLAYED_IMAGE_MSB(44, "Erase count displayed image LSB"),
    COUNTER_LAST_DISPLAY_UPDATE_STATUS(45, "Last display update status"),
    DISPLAY_UPDATES_TEMPFACTOR_13(46, "Temp 13 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_14(47, "Temp 14 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_15(48, "Temp 15 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_16(49, "Temp 16 updates"),
    COUNTER_ERROR_CODE_STATUS(50, "Error Code Status"),
    COUNTER_BUTTON_PRESS_TRIGGERED_MSB(51, "Button press triggered MSB"),
    COUNTER_BUTTON_PRESS_TRIGGERED_LSB(52, "Button press triggered LSB"),
    COUNTER_BUTTON_PRESS_ACCEPTED_MSB(53, "Button press accepted MSB"),
    COUNTER_BUTTON_PRESS_ACCEPTED_LSB(54, "Button press accepted LSB"),
    COUNTER_DATA_RECEIVER_ACTIVE_MS_MSB(55, "Data receiver active MS MSB"),
    COUNTER_DATA_RECEIVER_ACTIVE_MS_LSB(56, "Data receiver active MS LSB"),
    COUNTER_SYNC_HISTORY(57, "Sync history"),
    DISPLAY_UPDATES_TEMPFACTOR_18(58, "Temp 18 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_19(59, "Temp 19 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_20(60, "Temp 20 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_21(61, "Temp 21 updates"),
    DISPLAY_UPDATES_TEMPFACTOR_22(62, "Temp 22 updates"),
    COUNTER_DISPLAY_UPDATE_SECONDS_MSB(63, "Display update seconds MSB"),
    COUNTER_DISPLAY_UPDATE_SECONDS_LSB(64, "Display update seconds LSB"),
    COUNTER_LAST_DISPLAY_UPDATE_SECONDS(65, "Last display update seconds"),
    COUNTER_LED_BLINKS_MSB(66, "LED blinks MSB"),
    COUNTER_LED_BLINKS_LSB(67, "LED blinks LSB"),
    COUNTER_NFC_WAKEUPS_READING_ONLY(68, "NFC wakeups (reading only)"),
    COUNTER_NFC_WAKEUPS_ACTIVE_TRANSFER(69, "NFC wakeups (active transfer)"),
    COUNTER_DU_SLEEPTIMER_WAKEUPS(70, "DU sleep timer wakeups"),
    COUNTER_SLEEPTIMER_SYNC_TOO_LONG(71, "Label slept too long"),
    COUNTER_RUN_TIME_HOURS_MSB(72, "Run time hours MSB"),
    COUNTER_NORMAL_WAKEUPS_MSB(73, "Normal wakeups MSB"),
    COUNTER_NORMAL_WAKEUPS_LSB(74, "Normal wakeups LSB"),
    COUNTER_NUM_FASTSYNCS_2S_MSB(75, "Number of fastsyncs 2S MSB"),
    COUNTER_NUM_FASTSYNCS_2S_LSB(76, "Number of fastsyncs 2S LSB"),
    COUNTER_NUM_FASTSYNCS_4S_MSB(77, "Number of fastsyncs 4S MSB"),
    COUNTER_NUM_FASTSYNCS_4S_LSB(78, "Number of fastsyncs 4S LSB"),
    COUNTER_MISSED_SYNCS(79, "Missed syncs"),
    LABEL_COUNTER_80(80, "Label Counter 80"),
    LABEL_COUNTER_81(81, "Label Counter 81"),
    LABEL_COUNTER_82(82, "Label Counter 82"),
    LABEL_COUNTER_83(83, "Label Counter 83"),
    LABEL_COUNTER_84(84, "Label Counter 84"),
    LABEL_COUNTER_85(85, "Label Counter 85"),
    LABEL_COUNTER_86(86, "Label Counter 86"),
    LABEL_COUNTER_87(87, "Label Counter 87"),
    LABEL_COUNTER_88(88, "Label Counter 88"),
    LABEL_COUNTER_89(89, "Label Counter 89"),
    LABEL_COUNTER_90(90, "Label Counter 90"),
    LABEL_COUNTER_91(91, "Label Counter 91"),
    LABEL_COUNTER_92(92, "Label Counter 92"),
    LABEL_COUNTER_93(93, "Label Counter 93"),
    LABEL_COUNTER_94(94, "Label Counter 94"),
    LABEL_COUNTER_95(95, "Label Counter 95"),
    LABEL_COUNTER_96(96, "Label Counter 96"),
    LABEL_COUNTER_97(97, "Label Counter 97"),
    LABEL_COUNTER_98(98, "Label Counter 98"),
    LABEL_COUNTER_99(99, "Label Counter 99"),
    LABEL_COUNTER_100(100, "Label Counter 100"),
    LABEL_COUNTER_101(101, "Label Counter 101"),
    LABEL_COUNTER_102(102, "Label Counter 102"),
    LABEL_COUNTER_103(103, "Label Counter 103"),
    LABEL_COUNTER_104(104, "Label Counter 104"),
    LABEL_COUNTER_105(105, "Label Counter 105"),
    LABEL_COUNTER_106(106, "Label Counter 106"),
    LABEL_COUNTER_107(107, "Label Counter 107"),
    LABEL_COUNTER_108(108, "Label Counter 108"),
    LABEL_COUNTER_109(109, "Label Counter 109"),
    LABEL_COUNTER_110(110, "Label Counter 110"),
    LABEL_COUNTER_111(111, "Label Counter 111"),
    LABEL_COUNTER_112(112, "Label Counter 112"),
    LABEL_COUNTER_113(113, "Label Counter 113"),
    LABEL_COUNTER_114(114, "Label Counter 114"),
    LABEL_COUNTER_115(115, "Label Counter 115"),
    LABEL_COUNTER_116(116, "Label Counter 116"),
    LABEL_COUNTER_117(117, "Label Counter 117"),
    LABEL_COUNTER_118(118, "Label Counter 118"),
    LABEL_COUNTER_119(119, "Label Counter 119"),
    LABEL_COUNTER_120(120, "Label Counter 120"),
    LABEL_COUNTER_121(121, "Label Counter 121"),
    LABEL_COUNTER_122(122, "Label Counter 122"),
    LABEL_COUNTER_123(123, "Label Counter 123"),
    LABEL_COUNTER_124(124, "Label Counter 124"),
    LABEL_COUNTER_125(125, "Label Counter 125"),
    LABEL_COUNTER_126(126, "Label Counter 126"),
    LABEL_COUNTER_127(127, "Label Counter 127"),
    LABEL_COUNTER_128(128, "Label Counter 128"),
    LABEL_COUNTER_129(129, "Label Counter 129"),
    LABEL_COUNTER_130(130, "Label Counter 130"),
    LABEL_COUNTER_131(131, "Label Counter 131"),
    LABEL_COUNTER_132(132, "Label Counter 132"),
    LABEL_COUNTER_133(133, "Label Counter 133"),
    LABEL_COUNTER_134(134, "Label Counter 134"),
    LABEL_COUNTER_135(135, "Label Counter 135"),
    LABEL_COUNTER_136(136, "Label Counter 136"),
    LABEL_COUNTER_137(137, "Label Counter 137"),
    LABEL_COUNTER_138(138, "Label Counter 138"),
    LABEL_COUNTER_139(139, "Label Counter 139"),
    LABEL_COUNTER_140(140, "Label Counter 140"),
    LABEL_COUNTER_141(141, "Label Counter 141"),
    LABEL_COUNTER_142(142, "Label Counter 142"),
    LABEL_COUNTER_143(143, "Label Counter 143"),
    LABEL_COUNTER_144(144, "Label Counter 144"),
    LABEL_COUNTER_145(145, "Label Counter 145"),
    LABEL_COUNTER_146(146, "Label Counter 146"),
    LABEL_COUNTER_147(147, "Label Counter 147"),
    LABEL_COUNTER_148(148, "Label Counter 148"),
    LABEL_COUNTER_149(149, "Label Counter 149"),
    LABEL_COUNTER_150(150, "Label Counter 150"),
    LABEL_COUNTER_151(151, "Label Counter 151"),
    LABEL_COUNTER_152(152, "Label Counter 152"),
    LABEL_COUNTER_153(153, "Label Counter 153"),
    LABEL_COUNTER_154(154, "Label Counter 154"),
    LABEL_COUNTER_155(155, "Label Counter 155"),
    LABEL_COUNTER_156(156, "Label Counter 156"),
    LABEL_COUNTER_157(157, "Label Counter 157"),
    LABEL_COUNTER_158(158, "Label Counter 158"),
    LABEL_COUNTER_159(159, "Label Counter 159"),
    LABEL_COUNTER_160(160, "Label Counter 160"),
    LABEL_COUNTER_161(161, "Label Counter 161"),
    LABEL_COUNTER_162(162, "Label Counter 162"),
    LABEL_COUNTER_163(163, "Label Counter 163"),
    LABEL_COUNTER_164(164, "Label Counter 164"),
    LABEL_COUNTER_165(165, "Label Counter 165"),
    LABEL_COUNTER_166(166, "Label Counter 166"),
    LABEL_COUNTER_167(167, "Label Counter 167"),
    LABEL_COUNTER_168(168, "Label Counter 168"),
    LABEL_COUNTER_169(169, "Label Counter 169"),
    LABEL_COUNTER_170(170, "Label Counter 170"),
    LABEL_COUNTER_171(171, "Label Counter 171"),
    LABEL_COUNTER_172(172, "Label Counter 172"),
    LABEL_COUNTER_173(173, "Label Counter 173"),
    LABEL_COUNTER_174(174, "Label Counter 174"),
    LABEL_COUNTER_175(175, "Label Counter 175"),
    LABEL_COUNTER_176(176, "Label Counter 176"),
    LABEL_COUNTER_177(177, "Label Counter 177"),
    LABEL_COUNTER_178(178, "Label Counter 178"),
    LABEL_COUNTER_179(179, "Label Counter 179"),
    LABEL_COUNTER_180(180, "Label Counter 180"),
    LABEL_COUNTER_181(181, "Label Counter 181"),
    LABEL_COUNTER_182(182, "Label Counter 182"),
    LABEL_COUNTER_183(183, "Label Counter 183"),
    LABEL_COUNTER_184(184, "Label Counter 184"),
    LABEL_COUNTER_185(185, "Label Counter 185"),
    LABEL_COUNTER_186(186, "Label Counter 186"),
    LABEL_COUNTER_187(187, "Label Counter 187"),
    LABEL_COUNTER_188(188, "Label Counter 188"),
    LABEL_COUNTER_189(189, "Label Counter 189"),
    LABEL_COUNTER_190(190, "Label Counter 190"),
    LABEL_COUNTER_191(191, "Label Counter 191"),
    LABEL_COUNTER_192(192, "Label Counter 192"),
    LABEL_COUNTER_193(193, "Label Counter 193"),
    LABEL_COUNTER_194(194, "Label Counter 194"),
    LABEL_COUNTER_195(195, "Label Counter 195"),
    LABEL_COUNTER_196(196, "Label Counter 196"),
    LABEL_COUNTER_197(197, "Label Counter 197"),
    LABEL_COUNTER_198(198, "Label Counter 198"),
    LABEL_COUNTER_199(199, "Label Counter 199"),
    LABEL_COUNTER_200(200, "Label Counter 200"),
    LABEL_COUNTER_201(201, "Label Counter 201"),
    LABEL_COUNTER_202(202, "Label Counter 202"),
    LABEL_COUNTER_203(203, "Label Counter 203"),
    LABEL_COUNTER_204(204, "Label Counter 204"),
    LABEL_COUNTER_205(205, "Label Counter 205"),
    LABEL_COUNTER_206(206, "Label Counter 206"),
    LABEL_COUNTER_207(207, "Label Counter 207"),
    LABEL_COUNTER_208(208, "Label Counter 208"),
    LABEL_COUNTER_209(209, "Label Counter 209"),
    LABEL_COUNTER_210(210, "Label Counter 210"),
    LABEL_COUNTER_211(211, "Label Counter 211"),
    LABEL_COUNTER_212(212, "Label Counter 212"),
    LABEL_COUNTER_213(213, "Label Counter 213"),
    LABEL_COUNTER_214(214, "Label Counter 214"),
    LABEL_COUNTER_215(215, "Label Counter 215"),
    LABEL_COUNTER_216(216, "Label Counter 216"),
    LABEL_COUNTER_217(217, "Label Counter 217"),
    LABEL_COUNTER_218(218, "Label Counter 218"),
    LABEL_COUNTER_219(219, "Label Counter 219"),
    LABEL_COUNTER_220(220, "Label Counter 220"),
    LABEL_COUNTER_221(221, "Label Counter 221"),
    LABEL_COUNTER_222(222, "Label Counter 222"),
    LABEL_COUNTER_223(223, "Label Counter 223"),
    LABEL_COUNTER_224(224, "Label Counter 224"),
    LABEL_COUNTER_225(225, "Label Counter 225"),
    LABEL_COUNTER_226(226, "Label Counter 226"),
    LABEL_COUNTER_227(227, "Label Counter 227"),
    LABEL_COUNTER_228(228, "Label Counter 228"),
    LABEL_COUNTER_229(229, "Label Counter 229"),
    LABEL_COUNTER_230(230, "Label Counter 230"),
    LABEL_COUNTER_231(231, "Label Counter 231"),
    LABEL_COUNTER_232(232, "Label Counter 232"),
    LABEL_COUNTER_233(233, "Label Counter 233"),
    LABEL_COUNTER_234(234, "Label Counter 234"),
    LABEL_COUNTER_235(235, "Label Counter 235"),
    LABEL_COUNTER_236(236, "Label Counter 236"),
    LABEL_COUNTER_237(237, "Label Counter 237"),
    LABEL_COUNTER_238(238, "Label Counter 238"),
    LABEL_COUNTER_239(239, "Label Counter 239"),
    LABEL_COUNTER_240(240, "Label Counter 240"),
    LABEL_COUNTER_241(241, "Label Counter 241"),
    LABEL_COUNTER_242(242, "Label Counter 242"),
    LABEL_COUNTER_243(243, "Label Counter 243"),
    LABEL_COUNTER_244(244, "Label Counter 244"),
    LABEL_COUNTER_245(245, "Label Counter 245"),
    LABEL_COUNTER_246(246, "Label Counter 246"),
    LABEL_COUNTER_247(247, "Label Counter 247"),
    LABEL_COUNTER_248(248, "Label Counter 248"),
    LABEL_COUNTER_249(249, "Label Counter 249"),
    LABEL_COUNTER_250(250, "Label Counter 250"),
    LABEL_COUNTER_251(251, "Label Counter 251"),
    LABEL_COUNTER_252(252, "Label Counter 252"),
    LABEL_COUNTER_253(253, "Label Counter 253");

    private static final Map<Integer, LabelCounter> labelCounters;
    private final int counterId;
    private final String counterName;
    private final Integer errorThreshold;

    public static LabelCounter fromId(int id) {
        return labelCounters.get(id);
    }

    private LabelCounter(int counterId, String counterName, Integer errorThreshold) {
        this.counterId = counterId;
        this.counterName = counterName;
        this.errorThreshold = errorThreshold;
    }

    private LabelCounter(int counterId, String counterName) {
        this(counterId, counterName, null);
    }

    public int getCounterId() {
        return this.counterId;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public Integer getErrorThreshold() {
        return this.errorThreshold;
    }

    public boolean hasErrorThreshold() {
        return this.errorThreshold != null;
    }

    public boolean hasError(int counterValue) {
        return this.errorThreshold != null ? counterValue > this.errorThreshold : false;
    }

    static {
        labelCounters = new HashMap<Integer, LabelCounter>(LabelCounter.values().length);
        for (LabelCounter counter : LabelCounter.values()) {
            labelCounters.put(counter.counterId, counter);
        }
    }
}

