/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.updatetask.InternalCommandUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.InternalUpdateTaskCommit;
import java.util.Set;
import org.joda.time.DateTime;

public class JoinUpdateTask
extends InternalCommandUpdateTask {
    private final boolean accept;
    private final Set<WirelessChannel> channels;
    private final DateTime creationTime;

    public JoinUpdateTask(Address address, boolean accept, Set<WirelessChannel> channels, DateTime creationTime) {
        super(address, TaskPriority.JOIN, 5);
        this.accept = accept;
        this.channels = channels;
        this.creationTime = creationTime;
    }

    private JoinUpdateTask(Address address, boolean accept, Set<WirelessChannel> channels, int retriesLeft, DateTime creationTime) {
        super(address, TaskPriority.JOIN, retriesLeft);
        this.accept = accept;
        this.channels = channels;
        this.creationTime = creationTime;
    }

    public boolean isAccept() {
        return this.accept;
    }

    public Set<WirelessChannel> getChannels() {
        return this.channels;
    }

    public DateTime getCreationTime() {
        return this.creationTime;
    }

    @Override
    public boolean isRegistrationRequired() {
        return this.accept;
    }

    @Override
    public JoinUpdateTask createRetry() {
        return new JoinUpdateTask(this.getAddress(), this.accept, this.channels, Math.max(0, this.getRetriesLeft() - 1), this.creationTime);
    }

    @Override
    public void taskCommitted(InternalUpdateTaskCommit commit, DateTime now) {
        commit.joinCommitted(this.getAddress(), now, this.accept);
    }

    @Override
    public void taskFailed(InternalUpdateTaskCommit commit, DateTime now) {
        commit.joinFailed(this.getAddress(), now);
    }
}

