/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.accesspoint.CompressionProperties;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.updatetask.CompressedData;
import at.mrdevelopment.esl.updatetask.ExternalDataUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.encoding.CompressionMode;
import at.mrdevelopment.toolkit.encoding.DataEncoding;
import at.mrdevelopment.toolkit.image.ColorMapping;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageFactory;
import at.mrdevelopment.toolkit.image.RawImageProperties;
import at.mrdevelopment.toolkit.image.RawImageType;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;

public class ImageUpdateTask
extends ExternalDataUpdateTask {
    private final int size;
    private final Page page;
    private final boolean preload;
    private byte[] data;
    private CompressedData preparedData;
    private final boolean simulation;
    private final boolean isCompressed;
    private final CompressionMode compressionMode;

    public ImageUpdateTask(UUID taskId, Address address, TaskPriority priority, byte[] data, Page page, boolean preload) {
        super(taskId, address, priority);
        this.data = data;
        this.size = data != null ? data.length : 0;
        this.page = page;
        this.preload = preload;
        this.simulation = false;
        this.isCompressed = false;
        this.compressionMode = CompressionMode.UNDEFINED;
    }

    public ImageUpdateTask(UUID taskId, Address address, TaskPriority priority, byte[] data, Page page, boolean preload, boolean isCompressed, CompressionMode compressionMode) {
        super(null, address, priority);
        this.data = data;
        this.size = data != null ? data.length : 0;
        this.page = page;
        this.preload = preload;
        this.simulation = true;
        this.isCompressed = isCompressed;
        this.compressionMode = compressionMode;
    }

    public ImageUpdateTask(UUID taskId, Address address, TaskPriority priority, BufferedImage image, Page page, boolean preload) throws SerializeException {
        this(taskId, address, priority, ImageSerializer.toBytes((BufferedImage)image), page, preload);
    }

    public ImageUpdateTask(UUID taskId, Address address, TaskPriority priority, String encodedImage, Page page, boolean preload) throws SerializeException {
        this(taskId, address, priority, encodedImage != null && !encodedImage.isEmpty() ? DatatypeConverter.parseBase64Binary((String)encodedImage) : null, page, preload);
    }

    public Page getPage() {
        return this.page;
    }

    public boolean isPreload() {
        return this.preload;
    }

    public String getEncodedData() throws SerializeException {
        return this.data != null ? DatatypeConverter.printBase64Binary((byte[])this.data) : null;
    }

    @Override
    public boolean isCompressionAllowed() {
        return true;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public boolean hasPreparedData() {
        return this.preparedData != null;
    }

    public byte[] getData() {
        return this.preparedData.getEncodedImage().getEncodedBytes();
    }

    public boolean isCompressed() {
        return this.simulation ? this.isCompressed : this.preparedData.isCompressed();
    }

    public CompressionMode getCompressionMode() {
        return this.simulation ? this.compressionMode : this.preparedData.getEncodedImage().getEncodedImageProperties().getCompressionMode();
    }

    public CompressionProperties getCompressionProperties() {
        return new CompressionProperties(this.isCompressed(), this.getCompressionMode());
    }

    public void prepareCompressedDrivingData(LabelType labelType, DataEncoding encoding) throws SerializeException {
        if (!this.simulation) {
            this.preparedData = new CompressedData(this.getDrivingData(labelType), encoding);
            this.data = null;
        }
    }

    private RawImage getDrivingData(LabelType labelType) throws SerializeException {
        BufferedImage image = ImageSerializer.fromBytesUncached((byte[])this.data);
        RawImage rawImage = RawImageFactory.newImage((BufferedImage)image, (RawImageType)labelType.getRawImageType(), (ColorMapping[])labelType.getColorMappings());
        byte[] data = labelType.getDisplayDriving().toImage(rawImage);
        return RawImageFactory.newImage((int)image.getWidth(), (int)image.getHeight(), (byte[])data, (RawImageType)labelType.getRawImageType(), (RawImageProperties)rawImage.getRawImageProperties(), (ColorMapping[])labelType.getColorMappings());
    }
}

