/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.updatetask.InternalCommandUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.InternalUpdateTaskCommit;
import org.joda.time.DateTime;

public class EventConfirmUpdateTask
extends InternalCommandUpdateTask {
    private final int eventType;

    public EventConfirmUpdateTask(Address address, int eventType) {
        this(address, eventType, 5);
    }

    private EventConfirmUpdateTask(Address address, int eventType, int retriesLeft) {
        super(address, TaskPriority.HIGH, retriesLeft);
        this.eventType = eventType;
    }

    @Override
    public EventConfirmUpdateTask createRetry() {
        return new EventConfirmUpdateTask(this.getAddress(), this.eventType, Math.max(0, this.getRetriesLeft() - 1));
    }

    @Override
    public void taskCommitted(InternalUpdateTaskCommit commit, DateTime now) {
        commit.eventCommitted(this.getAddress(), now);
    }

    @Override
    public void taskFailed(InternalUpdateTaskCommit commit, DateTime now) {
        commit.eventFailed(this.getAddress(), now);
    }

    public int getEventType() {
        return this.eventType;
    }
}

