/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.update;

import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.update.UpdatePackageInformation;
import at.mrdevelopment.esl.update.UpdatePackageMismatchException;
import at.mrdevelopment.esl.xml.UpdatePackageXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.file.UpdateDecompressor;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class UpdatePackageValidator {
    private final UpdatePackageXMLSerializer serializer = new UpdatePackageXMLSerializer();

    public void validatePackage(File updatePackage, DeviceMode expectedDeviceMode) throws UpdatePackageMismatchException, IOException {
        InputStream stream = null;
        try {
            stream = UpdateDecompressor.untargzFile((File)updatePackage, (String)"update.xml", (boolean)false);
            if (stream == null) {
                throw new IOException("No update package information found");
            }
            UpdatePackageInformation packageInformation = this.serializer.parsePackageInformation(stream);
            if (packageInformation == null || !packageInformation.hasDeviceMode() || packageInformation.getDeviceMode() != expectedDeviceMode) {
                throw new IOException("The update package does not contain an update for this device type");
            }
        }
        catch (SerializeException exc) {
            try {
                throw new IOException(exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(stream);
                throw throwable;
            }
        }
        StreamUtils.close((InputStream)stream);
    }
}

