/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.Ping;
import at.mrdevelopment.esl.wireless.RxMetrics;
import at.mrdevelopment.toolkit.Version;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;

public class WakeupStatistic
implements Comparable<WakeupStatistic> {
    private final Address labelAddress;
    private final int accessPointId;
    private final long wakeupCount;
    private final DateTime lastPingReplyTime;
    private final Version firmwareVersion;
    private final SyncQuality syncQuality;
    private final PowerStatus powerStatus;
    private final boolean keyUnset;
    private final boolean keysNotProgrammed;
    private final Page currentPage;
    private final LabelErrors labelErrors;
    private final Integer lastRssi;
    private final Integer lastLqi;

    public WakeupStatistic(Address labelAddress, int accessPointId) {
        this(labelAddress, accessPointId, 0L, null, null, null, PowerStatus.UNKNOWN, true, true, null, null, null, null);
    }

    public WakeupStatistic(Address labelAddress, int accessPointId, long wakeupCount, DateTime pingReplyTime, Version firmwareVersion, SyncQuality syncQuality, PowerStatus powerStatus, boolean keyUnset, boolean keysNotProgrammed, Page currentPage, LabelErrors labelErrors, Integer rssi, Integer lqi) {
        this.labelAddress = labelAddress;
        this.accessPointId = accessPointId;
        this.wakeupCount = wakeupCount;
        this.lastPingReplyTime = pingReplyTime;
        this.firmwareVersion = firmwareVersion;
        this.syncQuality = syncQuality;
        this.powerStatus = powerStatus;
        this.keyUnset = keyUnset;
        this.keysNotProgrammed = keysNotProgrammed;
        this.currentPage = currentPage;
        this.labelErrors = labelErrors;
        this.lastRssi = rssi;
        this.lastLqi = lqi;
    }

    public WakeupStatistic processPing(Ping ping, RxMetrics rxMetrics) {
        DateTime pingReplyTime = ping.getTime();
        Version firmwareVersion = ping.getFirmwareVersion();
        SyncQuality syncQuality = ping.getSyncQuality();
        PowerStatus powerStatus = ping.getPowerStatus();
        boolean keyUnset = ping.isKeyUnset();
        boolean keysNotProgrammed = ping.areKeysNotProgrammed();
        Page currentPage = ping.getCurrentPage();
        LabelErrors labelErrors = ping.getLabelErrors();
        return new WakeupStatistic(this.labelAddress, this.accessPointId, this.wakeupCount + 1L, pingReplyTime, firmwareVersion, syncQuality, powerStatus, keyUnset, keysNotProgrammed, currentPage, labelErrors, rxMetrics.getRssi(), rxMetrics.getLqi());
    }

    public WakeupStatistic markKeyUnset(boolean keyUnset) {
        return new WakeupStatistic(this.labelAddress, this.accessPointId, this.wakeupCount > 0L ? this.wakeupCount + 1L : 0L, this.lastPingReplyTime, this.firmwareVersion, this.syncQuality, this.powerStatus, keyUnset, this.keysNotProgrammed, this.currentPage, this.labelErrors, this.lastRssi, this.lastLqi);
    }

    public Address getLabelAddress() {
        return this.labelAddress;
    }

    public int getAccessPointId() {
        return this.accessPointId;
    }

    public long getWakeupCount() {
        return this.wakeupCount;
    }

    public DateTime getLastPingReplyTime() {
        return this.lastPingReplyTime;
    }

    public Version getFirmwareVersion() {
        return this.firmwareVersion == null ? Version.UNDEFINED : this.firmwareVersion;
    }

    public SyncQuality getSyncQuality() {
        return this.syncQuality;
    }

    public PowerStatus getPowerStatus() {
        return this.powerStatus;
    }

    public boolean isKeyUnset() {
        return this.keyUnset;
    }

    public boolean areKeysNotProgrammed() {
        return this.keysNotProgrammed;
    }

    public boolean canReceiveKey() {
        return this.keyUnset && !this.keysNotProgrammed;
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }

    public LabelErrors getLabelErrors() {
        return this.labelErrors;
    }

    public boolean hasErrors() {
        return this.labelErrors != null ? this.labelErrors.hasErrors() : false;
    }

    public Integer getLastRssi() {
        return this.lastRssi;
    }

    public Integer getLastLqi() {
        return this.lastLqi;
    }

    public Minutes getMinutesSinceLastPingReply(DateTime now) {
        return this.lastPingReplyTime != null ? Minutes.minutesBetween((ReadableInstant)this.lastPingReplyTime, (ReadableInstant)now) : Minutes.MAX_VALUE;
    }

    @Override
    public int compareTo(WakeupStatistic other) {
        return this.labelAddress.compareTo(other.getLabelAddress());
    }

    public int hashCode() {
        return this.labelAddress.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof WakeupStatistic)) {
            return false;
        }
        WakeupStatistic other = (WakeupStatistic)object;
        if (!this.labelAddress.equals(other.labelAddress)) {
            return false;
        }
        return this.wakeupCount == other.wakeupCount;
    }
}

