/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import java.util.HashMap;
import java.util.Map;

public enum UpdateError {
    ERROR_CODE_UNLICENCED(1, "Label not licensed"),
    ERROR_CODE_INVALID_LABEL_ID(2, "Label ID not valid"),
    ERROR_CODE_UNREGISTERED(3, "Label not registered"),
    ERROR_CODE_PIN_MISSING(4, "Pin/registration code is missing or wrong"),
    ERROR_CODE_UNSUPPORTED_LABEL_TYPE(5, "Label type not supported"),
    ERROR_CODE_WRONG_DISPLAY_SIZE(10, "Image does not match display size"),
    ERROR_CODE_IMAGE_RENDERING(11, "Error during image rendering"),
    ERROR_CODE_IMAGE_CONVERSION(12, "Error during image conversion"),
    ERROR_CODE_INVALID_PAGE(13, "Invalid page"),
    ERROR_CODE_UNFINISHED_TASK_WAITING(14, "Could not process task because there are unfinished tasks waiting for this label"),
    ERROR_CODE_FIRMWARE_NOT_FOUND(15, "Firmware was not found for this label type"),
    ERROR_CODE_UNSUPPORTED_LED(16, "LED type not supported"),
    ERROR_CODE_INVALID_LED(17, "Invalid LED"),
    ERROR_CODE_TASK_NOT_ALLOWED(18, "This task is not allowed. In order to allow it, enable unlockAllTasks (at your own risk)"),
    ERROR_CODE_TEMPLATE_NOT_FOUND(20, "Template not found"),
    ERROR_CODE_TEMPLATE_PARSING(21, "Error during template parsing"),
    ERROR_CODE_TEMPLATE_CONTENT_CREATION(22, "Error during content document creation"),
    ERROR_CODE_CONTENT_NOT_AVAILABLE(23, "Content for image rendering not available"),
    ERROR_CODE_POWER_BAD(30, "Could not send update because label has insufficient power to perform the update"),
    ERROR_CODE_NO_ACKNOWLEDGE(31, "Update was not acknowledged by the label"),
    ERROR_CODE_TASK_IMPORT(40, "Failed to read the task"),
    ERROR_CODE_TRANSMITTER_COMMUNICATION(60, false, "Transmitter communication failure"),
    ERROR_CODE_UPDATE_LOST(61, false, "Update lost during processing on the access point"),
    ERROR_CODE_HTTP_COMMUNICATION(62, false, "HTTP communication error with the access point"),
    ERROR_CODE_AUTHENTICATION_FAILED(63, "Label authentication failed (wrong encryption key)"),
    ERROR_CODE_PIPELINE_HAZARD(64, false, "Task was removed from pipeline because previous transmission was not finished in time"),
    ERROR_CODE_TASK_NOT_PREPARED(65, false, "Task was not forwarded from pipeline due to timing constraints"),
    ERROR_CODE_COMMAND_NOT_STARTED(66, false, "Command forwarded but not started by access point"),
    ERROR_CODE_BARCODE_CREATION(70, "Error during barcode rendering"),
    ERROR_CODE_DATABASE(80, "Error while writing task to database"),
    ERROR_CODE_IO(90, "Input/output error"),
    ERROR_CODE_INTERNAL(91, "Other internal error"),
    ERROR_CODE_UNSUPPORTED_TASK(92, "Task type not supported"),
    ERROR_CODE_INVALID_STATE(93, "Task was in an invalid state"),
    ERROR_CODE_RESOURCE_NOT_AVAILABLE(94, "A required resource is not available"),
    ERROR_CODE_UNSUPPORTED_OPERATION(98, "Operation not supported"),
    ERROR_CODE_UNKNOWN(99, "Unknown error");

    private static final Map<Integer, UpdateError> errorsByCode;
    private final int code;
    private final boolean clearRetries;
    private final String description;

    private UpdateError(int code, String description) {
        this(code, true, description);
    }

    private UpdateError(int code, boolean clearRetries, String description) {
        this.code = code;
        this.clearRetries = clearRetries;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isClearRetries() {
        return this.clearRetries;
    }

    public String getDescription() {
        return this.description;
    }

    public static UpdateError valueOf(int errorCode) {
        UpdateError updateError = errorsByCode.get(errorCode);
        return updateError != null ? updateError : ERROR_CODE_UNKNOWN;
    }

    static {
        errorsByCode = new HashMap<Integer, UpdateError>();
        for (UpdateError updateError : UpdateError.values()) {
            errorsByCode.put(updateError.code, updateError);
        }
    }
}

