/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.type.LicencedFeature;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.AddressSequence;
import at.mrdevelopment.toolkit.Range;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class LicenceContent {
    static ESLLogger logger = ESLLogger.getLogger(LicenceContent.class);
    private final List<Range<Address>> labelRanges;
    private final Map<String, LicencedFeature> features;

    public LicenceContent(Set<LicencedFeature> features) {
        this(Collections.emptyList(), features);
    }

    public LicenceContent(List<Range<Address>> labelRanges, Set<LicencedFeature> features) {
        this.labelRanges = new ArrayList<Range<Address>>(labelRanges);
        this.features = new TreeMap<String, LicencedFeature>();
        for (LicencedFeature feature : features) {
            this.features.put(feature.getKey(), feature);
        }
    }

    public List<Range<Address>> getLabelRanges() {
        return Collections.unmodifiableList(this.labelRanges);
    }

    public SortedSet<LicencedFeature> getFeatures() {
        return Collections.unmodifiableSortedSet(new TreeSet<LicencedFeature>(this.features.values()));
    }

    public SortedSet<Address> getLabels() {
        TreeSet<Address> labels = new TreeSet<Address>();
        for (Range<Address> labelRange : this.labelRanges) {
            for (Address address : labelRange) {
                labels.add(address);
            }
        }
        return Collections.unmodifiableSortedSet(labels);
    }

    public List<Range<Address>> getOptimizedRanges() {
        ArrayList<Range> optimized = new ArrayList<Range>();
        SortedSet<Address> labels = this.getLabels();
        Address start = null;
        Address end = null;
        Address next = null;
        for (Address label : labels) {
            if (start == null) {
                start = label;
                end = label;
                next = (Address)new AddressSequence(label).next().value();
                continue;
            }
            if (label.equals(next)) {
                end = label;
                next = (Address)new AddressSequence(label).next().value();
                continue;
            }
            Range range = new Range((Comparable)start, (Comparable)end);
            optimized.add(range);
            start = label;
            end = label;
            next = (Address)new AddressSequence(label).next().value();
        }
        if (start != null) {
            Range range = new Range(start, end);
            optimized.add(range);
        }
        return Collections.unmodifiableList(optimized);
    }
}

