/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.type.LabelError;
import java.util.Set;

public class LabelErrors {
    private static final LabelErrors NO_ERRORS = new LabelErrors(0);
    private final int errorCode;

    public static LabelErrors valueOf(String errorCodeString) {
        return new LabelErrors(Integer.parseInt(errorCodeString));
    }

    public LabelErrors(int errorCode) {
        if (errorCode < 0 || errorCode > 255) {
            throw new IllegalArgumentException("Label error code is out of valid range");
        }
        this.errorCode = errorCode;
    }

    public byte toByte() {
        return (byte)(this.errorCode & 0xFF);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean hasErrors() {
        return this.errorCode > 0;
    }

    public Set<LabelError> getErrors() {
        return LabelError.getErrorsForCode(this.errorCode);
    }

    public boolean hasDisplayUpdateErrorDetected() {
        return LabelError.ERROR_FLAG_DISPLAY_UPDATE_FAILED.hasError(this.errorCode);
    }

    public boolean hasDisplayUpdateAtUnspecifiedTemperature() {
        return LabelError.ERROR_FLAG_TEMPERATURE.hasError(this.errorCode);
    }

    public boolean hasTotalNumberOfUpdatesExceeded() {
        return LabelError.ERROR_FLAG_TOTAL_DISPLAY_UPDATES.hasError(this.errorCode);
    }

    public boolean hasTotalNumberOfTransmissionsExceeded() {
        return LabelError.ERROR_FLAG_TOTAL_TRANSMISSIONS.hasError(this.errorCode);
    }

    public boolean hasFlashIntegrityErrors() {
        return LabelError.ERROR_FLAG_FLASH_INTEGRITY.hasError(this.errorCode);
    }

    public boolean hasUnexpectedResets() {
        return LabelError.ERROR_FLAG_RESETS.hasError(this.errorCode);
    }

    public boolean hasHighTransmissionFailedRate() {
        return LabelError.ERROR_FLAG_HIGH_TRANSMISSION_FAIL_RATE.hasError(this.errorCode);
    }

    public boolean hasOtherError() {
        return LabelError.ERROR_FLAG_OTHERS.hasError(this.errorCode);
    }

    public String toString() {
        return Integer.toString(this.errorCode);
    }

    public static LabelErrors createWithoutExperimentalLabelErrors(LabelErrors labelErrors) {
        if (labelErrors == null) {
            return null;
        }
        int error = labelErrors.getErrorCode();
        if (labelErrors.hasDisplayUpdateErrorDetected()) {
            error -= LabelError.ERROR_FLAG_DISPLAY_UPDATE_FAILED.getCode();
        }
        if (labelErrors.hasHighTransmissionFailedRate()) {
            error -= LabelError.ERROR_FLAG_HIGH_TRANSMISSION_FAIL_RATE.getCode();
        }
        if (labelErrors.hasUnexpectedResets()) {
            error -= LabelError.ERROR_FLAG_RESETS.getCode();
        }
        return LabelErrors.fromErrorCode(error);
    }

    public static LabelErrors fromErrorCode(int errorCode) {
        return errorCode == 0 ? NO_ERRORS : new LabelErrors(errorCode);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LabelErrors)) {
            return false;
        }
        LabelErrors that = (LabelErrors)other;
        return this.errorCode == that.errorCode;
    }
}

