/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.type.EANCode;
import org.junit.Test;

public class EANCodeTest {
    @Test
    public void validCocaCola() {
        EANCode eanCode = new EANCode("5449000000996");
        eanCode.validate();
    }

    @Test
    public void validCollegeBlock() {
        EANCode eanCode = new EANCode("9002244833018");
        eanCode.validate();
    }

    @Test
    public void validStabiloFaserscreiber() {
        EANCode eanCode = new EANCode("4006381399180");
        eanCode.validate();
    }

    @Test
    public void valid888888888888() {
        EANCode eanCode = new EANCode("8888888888888");
        eanCode.validate();
    }

    @Test
    public void validEAN8SuesstoffTabletten() {
        EANCode eanCode = new EANCode("24044691");
        eanCode.validate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidChecksum0() {
        EANCode eanCode = new EANCode("5449000000990");
        eanCode.validate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidChecksum1() {
        EANCode eanCode = new EANCode("5449000000991");
        eanCode.validate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidChecksum2() {
        EANCode eanCode = new EANCode("5449000000992");
        eanCode.validate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidChecksum3() {
        EANCode eanCode = new EANCode("5449000000993");
        eanCode.validate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidChecksum4() {
        EANCode eanCode = new EANCode("5449000000994");
        eanCode.validate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidChecksum5() {
        EANCode eanCode = new EANCode("5449000000995");
        eanCode.validate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidChecksum7() {
        EANCode eanCode = new EANCode("5449000000997");
        eanCode.validate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidChecksum8() {
        EANCode eanCode = new EANCode("5449000000998");
        eanCode.validate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidChecksum9() {
        EANCode eanCode = new EANCode("5449000000999");
        eanCode.validate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidChecksumEAN8() {
        EANCode eanCode = new EANCode("24044697");
        eanCode.validate();
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidCodeLength() {
        EANCode eanCode = new EANCode("1234567890");
        eanCode.validate();
    }
}

