/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

public class EANCode {
    public static final int EAN_8_CODE_LENGTH = 8;
    public static final int EAN_13_CODE_LENGTH = 13;
    private String articleNumber;

    public EANCode(String articleNumber) {
        this.articleNumber = articleNumber;
    }

    public void validate() throws IllegalArgumentException {
        if (this.articleNumber.isEmpty()) {
            throw new IllegalArgumentException("EAN code is empty");
        }
        if (!this.articleNumber.matches("\\d+")) {
            throw new IllegalArgumentException("EAN code contains illegal characters");
        }
        if (!this.isEAN8() && !this.isEAN13()) {
            throw new IllegalArgumentException(String.format("Invalid EAN code length (must be %d or %d digits)", 8, 13));
        }
        if (!this.isCheckSumValid()) {
            throw new IllegalArgumentException(String.format("Check sum is wrong (last digit should be %d)", this.calculateCheckSum()));
        }
    }

    public String getArticleNumber() {
        return this.articleNumber;
    }

    public String toString() {
        return String.format("<%s>", this.articleNumber);
    }

    public int hashCode() {
        return this.articleNumber == null ? 0 : this.articleNumber.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof EANCode)) {
            return false;
        }
        return this.articleNumber.equals(((EANCode)other).articleNumber);
    }

    public boolean isEAN8() {
        return this.articleNumber.length() == 8;
    }

    public boolean isEAN13() {
        return this.articleNumber.length() == 13;
    }

    public int getCheckSum() {
        return Character.digit(this.articleNumber.charAt(this.articleNumber.length() - 1), 10);
    }

    private int calculateCheckSum() {
        int sumOdd = 0;
        int sumEven = 0;
        for (int index = this.articleNumber.length() - 2; index >= 0; --index) {
            int digit = Character.digit(this.articleNumber.charAt(index), 10);
            if ((this.articleNumber.length() - index) % 2 == 0) {
                sumOdd += digit;
                continue;
            }
            sumEven += digit;
        }
        return (10 - (sumEven + 3 * sumOdd) % 10) % 10;
    }

    private boolean isCheckSumValid() {
        int checkSum = this.calculateCheckSum();
        return checkSum == this.getCheckSum();
    }

    public long getCode() {
        return Long.parseLong(this.articleNumber);
    }
}

