/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.type.EANCode;
import at.mrdevelopment.esl.type.Gtin;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;

public class ArticleNumber {
    public static final ArticleNumber INVALID = new ArticleNumber("");
    private final String articleNumber;

    public static ArticleNumber fromString(String articleNumber) {
        return new ArticleNumber(articleNumber.trim());
    }

    public static Collection<ArticleNumber> fromMultiString(String articleNumbers) {
        if (Strings.isNullOrEmpty((String)articleNumbers)) {
            return Collections.emptyList();
        }
        String[] articleNumberStrings = StringUtils.split((String)articleNumbers, (String)",");
        ArrayList<ArticleNumber> articleNumbersList = new ArrayList<ArticleNumber>(articleNumberStrings.length);
        for (String articleNumber : articleNumberStrings) {
            articleNumbersList.add(new ArticleNumber(articleNumber.trim()));
        }
        return articleNumbersList;
    }

    public static ArticleNumber fromLong(long articleNumber) {
        return new ArticleNumber(Long.toString(articleNumber));
    }

    public static ArticleNumber fromEan(EANCode ean) {
        return new ArticleNumber(ean.getArticleNumber());
    }

    private ArticleNumber(String articleNumber) {
        this.articleNumber = articleNumber;
    }

    public String toString() {
        return this.articleNumber;
    }

    public long toLong() throws NumberFormatException {
        return Long.parseLong(this.articleNumber);
    }

    public int hashCode() {
        return Long.valueOf(this.articleNumber).hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ArticleNumber articleNumber = (ArticleNumber)other;
        return this.articleNumber.equals(articleNumber.articleNumber);
    }

    public boolean isValid() {
        return !this.articleNumber.isEmpty();
    }

    public boolean isGtin() {
        String upperCase = this.articleNumber.toUpperCase();
        return upperCase.startsWith("EAN") || upperCase.startsWith("UPC") || upperCase.startsWith("GTIN");
    }

    public Gtin toGtin() throws IllegalStateException {
        String upperCase = this.articleNumber.toUpperCase();
        if (upperCase.startsWith("EAN")) {
            return Gtin.fromString(this.articleNumber.substring(3, this.articleNumber.length()));
        }
        if (upperCase.startsWith("UPC")) {
            return Gtin.fromString(this.articleNumber.substring(3, this.articleNumber.length()));
        }
        if (upperCase.startsWith("GTIN")) {
            return Gtin.fromString(this.articleNumber.substring(4, this.articleNumber.length()));
        }
        throw new IllegalStateException();
    }
}

