/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.toolkit.sql.SqlUtils;
import com.google.common.collect.Lists;
import java.util.Collection;

public enum TaskType {
    IMAGE("Show image and store image to page"),
    PRELOAD_IMAGE("Store image to page without updating display (preloading image)"),
    FIRMWARE("Update label firmware"),
    SWITCH_PAGE("Show preloaded content of specified page on display"),
    REFRESH_DISPLAY("Refreshes the currently shown image on the display"),
    QUERY_SENSOR("Query sensor value"),
    PROGRAM_KEYS("Program Pin, Puk and Preshared Key"),
    SET_CONFIG("Update value of configuration entry"),
    GET_CONFIG("Get current value of configuration entry"),
    RESET_ALL_COUNTERS("Clear all counter values"),
    RESET_COUNTER("Clear counter value"),
    QUERY_COUNTER("Query counter value"),
    FORCE_CHANNEL_SCAN("Force label to scan for access points on all channels"),
    REBOOT("Force a reboot"),
    PING("Ping label (connection test)"),
    REGISTER_LABEL("Register label to network"),
    UNREGISTER_LABEL("Unregister label from network"),
    UNLOCK_LABEL("Unlock label (removes network key)"),
    UNKNOWN("Unknown task"),
    AUX_PAGE("Program AUX page"),
    FLASHING("LED flashing"),
    NDEF_MESSAGE("Update NFC NDEF message");

    public static final String IMAGE_SQL;
    public static final Collection<TaskType> QUERY_TASKS;
    public static final String QUERY_TASKS_SQL;
    private final String description;

    private TaskType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isImage() {
        return this == IMAGE || this == PRELOAD_IMAGE;
    }

    public boolean isDisplayUpdate() {
        return this == IMAGE || this == SWITCH_PAGE || this == REFRESH_DISPLAY;
    }

    public boolean isLabelMaintenance() {
        return this == REGISTER_LABEL || this == UNREGISTER_LABEL;
    }

    public boolean isData() {
        return this.isImage() || this == FIRMWARE || this == AUX_PAGE;
    }

    public boolean isQuery() {
        return this == QUERY_COUNTER || this == QUERY_SENSOR || this == GET_CONFIG;
    }

    public boolean isCommand() {
        return !this.isData() && !this.isLabelMaintenance() && this != UNKNOWN;
    }

    public boolean isLicenceRequired() {
        return this != UNREGISTER_LABEL;
    }

    static {
        IMAGE_SQL = SqlUtils.getSqlCondition((Object[])new Object[]{IMAGE, PRELOAD_IMAGE});
        QUERY_TASKS = Lists.newArrayList((Object[])new TaskType[]{QUERY_COUNTER, QUERY_SENSOR, GET_CONFIG});
        QUERY_TASKS_SQL = SqlUtils.getSqlConditionFromCollection(QUERY_TASKS);
    }
}

