/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.SystemInfo;
import at.mrdevelopment.toolkit.Version;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractServiceStatusDataProvider {
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private final SystemInfo systemInfo = new SystemInfo();

    public void initServiceStatus(ServiceStatus serviceStatus, Version version) throws InitializationException {
        serviceStatus.setProperty("status", ConnectionStatus.ONLINE.toString());
        serviceStatus.setProperty("version", version.toString());
        serviceStatus.setProperty("build", version.getBuild());
        serviceStatus.setProperty("java-runtime-name", this.systemInfo.getJavaRuntimeName());
        serviceStatus.setProperty("java-runtime-version", this.systemInfo.getJavaRuntimeVersion());
        serviceStatus.setProperty("java-vm-name", this.systemInfo.getJavaVmName());
        serviceStatus.setProperty("java-home", this.systemInfo.getJavaHome());
        serviceStatus.setProperty("os-name", this.systemInfo.getOsName());
        serviceStatus.setProperty("os-arch", this.systemInfo.getOsArch());
        serviceStatus.setProperty("os-version", this.systemInfo.getOsVersion());
        serviceStatus.setProperty("available-processors", this.systemInfo.getAvailableProcessors());
        serviceStatus.setProperty("default-encoding", this.systemInfo.getDefaultEncoding());
        serviceStatus.setProperty("cwd", this.systemInfo.getCwd());
    }

    protected void updateNetworkProperties(ServiceStatus serviceStatus, boolean resolveHostname) throws InitializationException {
        EnvironmentProperties environment = new EnvironmentProperties(resolveHostname);
        serviceStatus.setProperty("ip-address", environment.getIPAddress());
        serviceStatus.setProperty("mac-address", environment.getMacAddress());
        serviceStatus.setProperty("os-type", environment.getOperatingSystem());
        serviceStatus.setProperty("uuid", environment.getUUID());
        serviceStatus.setProperty("adapter-name", environment.getAdapterName());
        serviceStatus.setProperty("adapter-interface", environment.getInterfaceName());
        serviceStatus.setProperty("hostname", environment.getHostName());
        serviceStatus.setProperty("java-gc", environment.getGarbageCollector());
    }

    public void updateServiceStatus(ServiceStatus serviceStatus) {
        serviceStatus.setProperty("service-uptime", this.systemInfo.getUptime());
        serviceStatus.setProperty("server-time", FORMATTER.print((ReadableInstant)DateTime.now()));
        serviceStatus.setProperty("max-memory", this.systemInfo.getMaxMemory());
        serviceStatus.setProperty("free-memory", this.systemInfo.getFreeMemory());
        serviceStatus.setProperty("total-memory", this.systemInfo.getTotalMemory());
        serviceStatus.setProperty("used-memory", this.systemInfo.getUsedMemory());
        serviceStatus.setProperty("threads", this.systemInfo.getActiveThreads());
    }
}

