/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.roaming;

import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.roaming.InternalRoamingTable;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.SyncProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;

public class ThinInternalRoamingTable
implements InternalRoamingTable {
    private List<ArrayList<Address>> assignedLabelsBySlot = new ArrayList<ArrayList<Address>>(1024);
    private Set<Address> assignedLabelsUnmodifiable;
    private Set<Address> registeredLabels;
    private Set<WirelessChannel> usedChannels;
    private Map<Address, LabelType> labelTypes;
    private Map<Address, Pin> pins;
    private int assignedLabelsCount;
    private DateTime updateTime;
    private boolean isValid;
    private int validTimeInMinutes;
    private int pingIntervalInMinutes;
    private boolean acceptAllLabels;
    private String remoteHostName;
    private String remoteHostAddress;
    private Key key;
    private int protocolId;
    private SyncProfile syncProfile;
    private boolean encryptionRequired;

    public ThinInternalRoamingTable() {
        this.initAssignedLabelsBySlot();
        this.assignedLabelsUnmodifiable = Collections.unmodifiableSet(Collections.emptySet());
        this.registeredLabels = Collections.emptySet();
        this.usedChannels = Collections.emptySet();
        this.labelTypes = Collections.emptyMap();
        this.pins = Collections.emptyMap();
        this.assignedLabelsCount = 0;
        this.updateTime = DateTime.now();
        this.isValid = false;
        this.validTimeInMinutes = 10;
        this.pingIntervalInMinutes = 0;
        this.acceptAllLabels = false;
        this.remoteHostName = "";
        this.remoteHostAddress = "";
        this.key = Key.emptyKey();
        this.protocolId = 0;
        this.syncProfile = SyncProfile.RETAIL_DEFAULT;
        this.encryptionRequired = false;
    }

    private void initAssignedLabelsBySlot() {
        for (int slotId = 0; slotId < 1024; ++slotId) {
            this.assignedLabelsBySlot.add(slotId, new ArrayList(4));
        }
    }

    @Override
    public Collection<Address> getAssignedLabelsForSlot(int slotId) {
        return Collections.unmodifiableList((List)this.assignedLabelsBySlot.get(slotId));
    }

    @Override
    public Set<Address> getAssignedLabels() {
        return this.assignedLabelsUnmodifiable;
    }

    @Override
    public int getAssignedLabelsCount() {
        return this.assignedLabelsCount;
    }

    @Override
    public int getRegisteredLabelsCount() {
        return this.registeredLabels.size();
    }

    @Override
    public Set<Address> getRegisteredLabels() {
        return Collections.unmodifiableSet(this.registeredLabels);
    }

    @Override
    public Set<WirelessChannel> getUsedChannels() {
        return Collections.unmodifiableSet(this.usedChannels);
    }

    @Override
    public int getValidTimeInMinutes() {
        return this.validTimeInMinutes;
    }

    @Override
    public int getPingIntervalInMinutes() {
        return this.pingIntervalInMinutes;
    }

    @Override
    public boolean isAcceptAllLabels() {
        return this.acceptAllLabels;
    }

    @Override
    public DateTime getUpdateTime() {
        return this.updateTime;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public String getRemoteHostName() {
        return this.remoteHostName;
    }

    @Override
    public String getRemoteHostAddress() {
        return this.remoteHostAddress;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public boolean hasKey() {
        return !this.key.isEmptyKey();
    }

    @Override
    public Pin getPin(Address labelAddress) {
        return this.pins.get(labelAddress);
    }

    @Override
    public boolean hasPin(Address labelAddress) {
        return this.pins.containsKey(labelAddress);
    }

    @Override
    public boolean isTimedOut(DateTime now) {
        return Minutes.minutesBetween((ReadableInstant)this.updateTime, (ReadableInstant)now).getMinutes() >= this.validTimeInMinutes;
    }

    @Override
    public boolean isLabelRegistered(Address labelAddress) {
        return this.acceptAllLabels || this.registeredLabels.contains(labelAddress);
    }

    @Override
    public String getUsedChannelsString() {
        return String.format("[%s]", StringUtils.join(this.usedChannels, (String)", "));
    }

    @Override
    public int getProtocoId() {
        return this.protocolId;
    }

    @Override
    public LabelType getLabelType(Address address) {
        return this.labelTypes.get(address);
    }

    @Override
    public SyncProfile getSyncProfile() {
        return this.syncProfile;
    }

    @Override
    public boolean isEncryptionRequired() {
        return this.encryptionRequired;
    }

    private ThinInternalRoamingTable(Builder builder) {
        this.assignedLabelsBySlot = builder.assignedLabelsBySlot;
        this.assignedLabelsUnmodifiable = Collections.unmodifiableSet(builder.assignedLabels);
        this.registeredLabels = builder.registeredLabels;
        this.usedChannels = builder.usedChannels;
        this.labelTypes = builder.labelTypes;
        this.pins = builder.pins;
        this.assignedLabelsCount = builder.assignedLabelsCount;
        this.updateTime = builder.updateTime;
        this.isValid = builder.isValid;
        this.validTimeInMinutes = builder.validTimeInMinutes;
        this.pingIntervalInMinutes = builder.pingIntervalInMinutes;
        this.acceptAllLabels = builder.acceptAllLabels;
        this.remoteHostName = builder.remoteHostName;
        this.remoteHostAddress = builder.remoteHostAddress;
        this.key = builder.key != null ? builder.key : Key.emptyKey();
        this.protocolId = builder.protocolId;
        this.syncProfile = builder.syncProfile;
        this.encryptionRequired = builder.encryptionRequired;
    }

    public static class Builder {
        private List<ArrayList<Address>> assignedLabelsBySlot;
        private Set<Address> assignedLabels;
        private Set<Address> registeredLabels;
        private Set<WirelessChannel> usedChannels;
        private Map<Address, LabelType> labelTypes;
        private Map<Address, Pin> pins;
        private int assignedLabelsCount;
        private DateTime updateTime;
        private boolean isValid;
        private int validTimeInMinutes;
        private int pingIntervalInMinutes;
        private boolean acceptAllLabels;
        private String remoteHostName;
        private String remoteHostAddress;
        private Key key;
        private int protocolId;
        private SyncProfile syncProfile;
        private boolean encryptionRequired;

        public Builder assignedLabelsBySlot(List<ArrayList<Address>> assignedLabelsBySlot) {
            this.assignedLabelsBySlot = assignedLabelsBySlot;
            return this;
        }

        public Builder assignedLabels(Set<Address> assignedLabels) {
            this.assignedLabels = assignedLabels;
            return this;
        }

        public Builder registeredLabels(Set<Address> registeredLabels) {
            this.registeredLabels = registeredLabels;
            return this;
        }

        public Builder usedChannels(Set<WirelessChannel> usedChannels) {
            this.usedChannels = usedChannels;
            return this;
        }

        public Builder labelTypes(Map<Address, LabelType> labelTypes) {
            this.labelTypes = labelTypes;
            return this;
        }

        public Builder pins(Map<Address, Pin> pins) {
            this.pins = pins;
            return this;
        }

        public Builder assignedLabelsCount(int assignedLabelsCount) {
            this.assignedLabelsCount = assignedLabelsCount;
            return this;
        }

        public Builder updateTime(DateTime updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public Builder isValid(boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        public Builder validTimeInMinutes(int validTimeInMinutes) {
            this.validTimeInMinutes = validTimeInMinutes;
            return this;
        }

        public Builder pingIntervalInMinutes(int pingIntervalInMinutes) {
            this.pingIntervalInMinutes = pingIntervalInMinutes;
            return this;
        }

        public Builder acceptAllLabels(boolean acceptAllLabels) {
            this.acceptAllLabels = acceptAllLabels;
            return this;
        }

        public Builder remoteHostName(String remoteHostName) {
            this.remoteHostName = remoteHostName;
            return this;
        }

        public Builder remoteHostAddress(String remoteHostAddress) {
            this.remoteHostAddress = remoteHostAddress;
            return this;
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder protocolId(int protocolId) {
            this.protocolId = protocolId;
            return this;
        }

        public Builder syncProfile(SyncProfile syncProfile) {
            this.syncProfile = syncProfile;
            return this;
        }

        public Builder encryptionRequired(boolean encryptionRequired) {
            this.encryptionRequired = encryptionRequired;
            return this;
        }

        public ThinInternalRoamingTable build() {
            return new ThinInternalRoamingTable(this);
        }
    }
}

