/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.provisioning;

import com.google.common.primitives.Ints;
import java.security.SecureRandom;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class ClaimId {
    private static final int CLAIM_ID_PART_COUNT = 4;
    private static final int CLAIM_ID_PART_LENGTH = 4;
    private final int[] claimIdParts;

    public static ClaimId fromString(String claimIdString) throws IllegalArgumentException {
        String[] splitted = StringUtils.split((String)claimIdString, (String)"-");
        int[] claimIdParts = new int[splitted.length];
        for (int index = 0; index < splitted.length; ++index) {
            claimIdParts[index] = Integer.valueOf(splitted[index]);
        }
        return new ClaimId(claimIdParts);
    }

    private ClaimId(int[] claimIdParts) throws IllegalArgumentException {
        this.validate(claimIdParts);
        this.claimIdParts = Arrays.copyOf(claimIdParts, claimIdParts.length);
    }

    private void validate(int[] claimIdParts) throws IllegalArgumentException {
        if (claimIdParts == null || claimIdParts.length != 4) {
            throw new IllegalArgumentException("Invalid claim ID");
        }
        for (int claimIdPart : claimIdParts) {
            if ((int)Math.log10(claimIdPart) + 1 <= 4) continue;
            throw new IllegalArgumentException("Claim ID contains invalid part");
        }
    }

    public String getClaimIdString() {
        return Ints.join((String)"-", (int[])this.claimIdParts);
    }

    public String toString() {
        return this.getClaimIdString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public static ClaimId generateRandomClaimId() {
        int index;
        SecureRandom random = new SecureRandom();
        int[] parts = new int[4];
        int seed = 1;
        for (index = 0; index < 4; ++index) {
            seed *= 10;
        }
        for (index = 0; index < 4; ++index) {
            parts[index] = random.nextInt(seed);
        }
        return new ClaimId(parts);
    }
}

