/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing.model;

import at.mrdevelopment.esl.core.ServiceAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ServiceAddressListModel
implements ListModel {
    private List<ServiceAddress> serviceAddresses;
    private Set<ListDataListener> listeners = new HashSet<ListDataListener>();
    private int selectedIndex = -1;

    public ServiceAddressListModel(List<ServiceAddress> serviceAddresses) {
        if (serviceAddresses != null) {
            this.serviceAddresses = serviceAddresses;
        } else {
            serviceAddresses = new ArrayList<ServiceAddress>();
        }
    }

    public ServiceAddressListModel() {
        this.serviceAddresses = new ArrayList<ServiceAddress>();
    }

    @Override
    public int getSize() {
        return this.serviceAddresses.size();
    }

    public Object getElementAt(int index) {
        ServiceAddress serviceAddress = this.serviceAddresses.get(index);
        if (serviceAddress != null) {
            String selectedString = "";
            if (this.selectedIndex == index) {
                selectedString = " (selected)";
            }
            return serviceAddress.getHost() + ":" + serviceAddress.getPort() + selectedString;
        }
        return null;
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyContentChanged() {
        for (ListDataListener listener : this.listeners) {
            listener.intervalAdded(new ListDataEvent(this, 0, 0, this.serviceAddresses.size()));
        }
    }

    public void removeServiceAddress(int index) {
        this.serviceAddresses.remove(index);
        this.notifyContentChanged();
    }

    public void addServiceAddress(ServiceAddress serviceAddress) {
        if (!this.contains(serviceAddress)) {
            this.serviceAddresses.add(serviceAddress);
            this.notifyContentChanged();
        }
    }

    public List<ServiceAddress> getServiceAddresses() {
        return this.serviceAddresses;
    }

    private boolean contains(ServiceAddress serviceAddress) {
        for (ServiceAddress currentServiceAddress : this.serviceAddresses) {
            if (!serviceAddress.getConnectionString().equals(currentServiceAddress.getConnectionString())) continue;
            return true;
        }
        return false;
    }

    public void setSelected(ServiceAddress serviceAddress) {
        int index = this.serviceAddresses.indexOf(serviceAddress);
        if (index >= 0) {
            this.selectedIndex = index;
            this.notifyContentChanged();
        }
    }

    public ServiceAddress getServiceAddress(int index) {
        return this.serviceAddresses.get(index);
    }

    public ServiceAddress getSelected() {
        if (this.selectedIndex >= 0) {
            return this.serviceAddresses.get(this.selectedIndex);
        }
        return null;
    }
}

