/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing;

import at.mrdevelopment.toolkit.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class BroadcastMessageReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readMessageString(byte[] data) throws IOException, ClassNotFoundException {
        if (data == null || data.length < 8) {
            throw new IOException("Invalid broadcast message data");
        }
        if (this.isCreatedFromObjectOutputStream(data)) {
            ByteArrayInputStream dataStream = new ByteArrayInputStream(data);
            ObjectInputStream objectInputStream = new ObjectInputStream(dataStream);
            try {
                String string = (String)objectInputStream.readObject();
                return string;
            }
            finally {
                StreamUtils.close((InputStream)objectInputStream);
                StreamUtils.close((InputStream)dataStream);
            }
        }
        return new String(data, "UTF-8");
    }

    private boolean isCreatedFromObjectOutputStream(byte[] data) {
        short header = (short)(data[0] << 8 | data[1] & 0xFF);
        short version = (short)(data[2] << 8 | data[3] & 0xFF);
        byte message_type = data[4];
        int length = (data[5] & 0xFF) << 8 | data[6] & 0xFF;
        return header == -21267 && version == 5 && message_type == 116 && length > 0;
    }
}

