/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing;

import at.mrdevelopment.esl.processing.BroadcastMessageReader;
import at.mrdevelopment.esl.processing.BroadcastProcessor;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;

public class BroadcastListener
extends Thread
implements Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(BroadcastListener.class);
    private static final int PACKET_SIZE = 5000;
    private final BroadcastProcessor processor;
    private final DatagramSocket socket;
    private final BroadcastMessageReader reader;
    private volatile boolean shutdownRequested = false;

    public BroadcastListener(BroadcastProcessor processor, int port, String bindAddress) throws InitializationException {
        this.processor = processor;
        this.reader = new BroadcastMessageReader();
        try {
            this.socket = new DatagramSocket(port, bindAddress != null ? InetAddress.getByName(bindAddress) : InetAddress.getByName("0.0.0.0"));
        }
        catch (SocketException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (UnknownHostException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    @Override
    public void run() {
        byte[] recvBuf = new byte[5000];
        DatagramPacket recvPacket = new DatagramPacket(recvBuf, recvBuf.length);
        while (!this.shutdownRequested) {
            try {
                String message = this.receiveMessage(recvPacket);
                this.processor.processBroadcast(message, recvPacket.getAddress().getHostAddress());
            }
            catch (InterruptedException ignore) {
            }
            catch (IOException exc) {
                logger.warn("Failed to read access point broadcast packet");
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            catch (Exception exc) {
                logger.error("Unknown exception during processing of access point broadcast packet");
                logger.logException((Throwable)exc);
            }
        }
    }

    public void shutdown() {
        logger.info("Shutdown BroadcastListener thread");
        this.shutdownRequested = true;
        this.socket.close();
    }

    protected String receiveMessage(DatagramPacket recvPacket) throws IOException, InterruptedException, ClassNotFoundException {
        byte[] data = this.receiveFromSocket(recvPacket);
        return this.reader.readMessageString(data);
    }

    private byte[] receiveFromSocket(DatagramPacket recvPacket) throws IOException, InterruptedException {
        try {
            this.socket.receive(recvPacket);
            return Arrays.copyOfRange(recvPacket.getData(), recvPacket.getOffset(), recvPacket.getLength());
        }
        catch (SocketException exc) {
            if (!this.shutdownRequested) {
                throw exc;
            }
            throw new InterruptedException();
        }
    }

    protected DatagramSocket getSocket() {
        return this.socket;
    }

    protected BroadcastProcessor getProcessor() {
        return this.processor;
    }
}

