/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.record;

import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.record.Identifiable;
import org.joda.time.DateTime;

public class TransactionStatusInfo
implements Identifiable {
    private Long id = null;
    private String title = null;
    private int taskCount = 0;
    private long externalId = 0L;
    private int totalUpdates = 0;
    private int finishedUpdates = 0;
    private int errorUpdates = 0;
    private DateTime startedTime = null;
    private DateTime lastUpdateTime = null;

    public static TransactionStatusInfo createEmptyTransactionInfo() {
        DateTime now = DateTime.now();
        return new TransactionStatusInfo(0L, "Empty transaction", 0, 0L, 0, 0, 0, now, now);
    }

    public TransactionStatusInfo() {
    }

    public TransactionStatusInfo(long id, String title, int taskCount, long externalId, int totalUpdates, int finishedUpdates, int errorUpdates, DateTime startedTime, DateTime lastUpdateTime) {
        this.id = id;
        this.title = title;
        this.taskCount = taskCount;
        this.externalId = externalId;
        this.totalUpdates = totalUpdates;
        this.finishedUpdates = finishedUpdates;
        this.errorUpdates = errorUpdates;
        this.startedTime = startedTime;
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    @Serialize
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Serialize
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Serialize
    public Integer getTaskCount() {
        return this.taskCount;
    }

    public void setTaskCount(Integer taskCount) {
        this.taskCount = taskCount;
    }

    @Serialize
    public Long getExternalId() {
        return this.externalId;
    }

    public void setExternalId(Long externalId) {
        this.externalId = externalId;
    }

    @Serialize
    public Integer getTotalUpdates() {
        return this.totalUpdates;
    }

    public void setTotalUpdates(Integer totalUpdates) {
        this.totalUpdates = totalUpdates;
    }

    @Serialize
    public Integer getFinishedUpdates() {
        return this.finishedUpdates;
    }

    public void setFinishedUpdates(Integer finishedUpdates) {
        this.finishedUpdates = finishedUpdates;
    }

    @Serialize
    public Integer getErrorUpdates() {
        return this.errorUpdates;
    }

    public void setErrorUpdates(Integer errorUpdates) {
        this.errorUpdates = errorUpdates;
    }

    @Serialize
    public DateTime getStartedTime() {
        return this.startedTime;
    }

    public void setStartedTime(DateTime startedTime) {
        this.startedTime = startedTime;
    }

    @Serialize
    public DateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(DateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public int getWaitingUpdates() {
        return Math.max(this.taskCount, this.totalUpdates) - this.finishedUpdates;
    }

    public boolean isStarted() {
        return true;
    }

    public boolean isFinished() {
        return Math.max(this.taskCount, this.totalUpdates) == this.finishedUpdates;
    }

    public boolean isFailed() {
        return this.errorUpdates > 0;
    }

    @Override
    public String getIdentifier() {
        return String.format("%d", this.id);
    }

    @Override
    public String getName() {
        return String.format("%d", this.id);
    }
}

