/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.AbstractDatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.query.ScrollableQueryResult;
import java.util.Collections;
import java.util.List;

public abstract class ListDatasetQuery<T, S>
extends AbstractDatasetQuery<T, S> {
    private final String url;
    private final Class<T> recordClass;
    private final Class<S> parameterClass;
    private final boolean singleRecordExpected;

    public ListDatasetQuery(String url, Class<T> recordClass, Class<S> parameterClass) {
        this(url, recordClass, parameterClass, false);
    }

    public ListDatasetQuery(String url, Class<T> recordClass, Class<S> parameterClass, boolean singeRecordExcpected) {
        this.url = url;
        this.recordClass = recordClass;
        this.parameterClass = parameterClass;
        this.singleRecordExpected = singeRecordExcpected;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Class<T> getRecordClass() {
        return this.recordClass;
    }

    @Override
    public List<String> getCustomFields() {
        return Collections.emptyList();
    }

    @Override
    public Class<S> getParameterClass() {
        return this.parameterClass;
    }

    @Override
    public boolean isSingleRecordExpected() {
        return this.singleRecordExpected;
    }

    @Override
    public QueryResult<T> getResult(QueryRestriction<S> queryRestriction, Transaction<?> transaction) throws DatasetException {
        List<T> list = this.getRecords(queryRestriction.getSearchKey(), transaction);
        if (queryRestriction.isPagedResults()) {
            ScrollableQueryResult<T> fullResults = new ScrollableQueryResult<T>(list);
            QueryResult<T> pageResults = fullResults.getResultsForPage(queryRestriction.getPage(), queryRestriction.getRecordsPerPage());
            List<T> records = pageResults.getRecords();
            return QueryResult.newPagedResult(records, fullResults.getTotalRecords(), queryRestriction.getPage(), queryRestriction.getRecordsPerPage());
        }
        return QueryResult.newUnpagedResult(list);
    }

    @Override
    public int getCount(QueryRestriction<S> queryRestriction, Transaction<?> transaction) throws DatasetException {
        return this.getRecords(queryRestriction.getSearchKey(), transaction).size();
    }

    protected abstract List<T> getRecords(S var1, Transaction<?> var2) throws DatasetException;
}

