/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetField;
import at.mrdevelopment.esl.persistence.DatasetListener;
import at.mrdevelopment.esl.persistence.DatasetModifiedListener;
import at.mrdevelopment.esl.persistence.DatasetReloadListener;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import java.util.Collection;
import java.util.List;

public interface Dataset<T extends Commitable>
extends DatasetModifiedListener<T> {
    public Class<T> getRecordClass();

    public DatasetQuery<T, Void> getDefaultQuery();

    public boolean hasDefaultQuery();

    public T queryById(long var1, Transaction<?> var3) throws DatasetException;

    public List<T> queryAll(Transaction<?> var1) throws DatasetException;

    public List<T> queryPage(int var1, int var2, Transaction<?> var3) throws DatasetException;

    public int getRecordCount(Transaction<?> var1) throws DatasetException;

    public void store(T var1, UserId var2, Transaction<?> var3) throws DatasetException;

    public void store(Collection<T> var1, UserId var2, Transaction<?> var3) throws DatasetException;

    public void delete(T var1, UserId var2, Transaction<?> var3) throws DatasetException;

    public void delete(Collection<T> var1, UserId var2, Transaction<?> var3) throws DatasetException;

    public void refresh(T var1, Transaction<?> var2) throws DatasetException;

    public void clear(Transaction<?> var1) throws DatasetException;

    public T newRecord() throws DatasetException;

    public Abortable reload(Transaction<?> var1) throws DatasetException;

    public boolean hasInsertPermission(Role var1);

    public boolean hasUpdatePermission(Role var1);

    public boolean hasDeletePermission(Role var1);

    public boolean hasQueryPermission(Role var1);

    public void addDatasetListener(DatasetListener<T> var1);

    public void removeDatasetListener(DatasetListener<T> var1);

    public void addDatasetModifiedListener(DatasetModifiedListener<T> var1);

    public void removeDatasetModifiedListener(DatasetModifiedListener<T> var1);

    public void addDatasetReloadListener(DatasetReloadListener var1);

    public void removeDatasetReloadListener(DatasetReloadListener var1);

    public Collection<DatasetField> getDatasetFields();

    public DatasetField getDatasetField(String var1);

    public List<String> getCustomFields();

    public void close();
}

