/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetField;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.IndexedDataset;
import at.mrdevelopment.esl.persistence.dataset.PagedDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DatasetRegistry {
    static ESLLogger logger = ESLLogger.getLogger(DatasetRegistry.class);
    private final Map<Class<? extends Commitable>, Dataset<? extends Commitable>> datasets = new HashMap<Class<? extends Commitable>, Dataset<? extends Commitable>>();

    public DatasetField getDatasetField(Class<?> recordClass, String internalName) {
        return this.datasets.get(recordClass).getDatasetField(internalName);
    }

    public <T extends Commitable> Dataset<T> getDataset(Class<T> recordClass) {
        return this.datasets.get(recordClass);
    }

    public <C, T> C getDataset(Class<T> recordClass, Class<C> castClass) {
        return castClass.cast(this.datasets.get(recordClass));
    }

    public <T extends Commitable> IndexedDataset<T> getIndexedDataset(Class<T> recordClass) {
        return (IndexedDataset)this.datasets.get(recordClass);
    }

    public <T extends Commitable> PagedDataset<T> getPagedDataset(Class<T> recordClass) {
        return (PagedDataset)this.datasets.get(recordClass);
    }

    public <T extends Commitable> Dataset<T> getDatasetByEntityName(String entityName) {
        for (Dataset<? extends Commitable> dataset : this.datasets.values()) {
            String datasetEntityName = dataset.getRecordClass().getSimpleName().toLowerCase();
            if (datasetEntityName.equals(entityName.toLowerCase())) {
                return dataset;
            }
            if (!datasetEntityName.equals(entityName.toLowerCase() + "record")) continue;
            return dataset;
        }
        return null;
    }

    public void reload(Transaction<?> transaction) throws DatasetException, SerializeException {
        for (Dataset<? extends Commitable> dataset : this.datasets.values()) {
            dataset.reload(transaction);
        }
    }

    public Set<Class<? extends Commitable>> getRegisteredRecordClasses() {
        return this.datasets.keySet();
    }

    public void close() {
        logger.info("Closing open datasets");
        for (Dataset<? extends Commitable> dataset : this.datasets.values()) {
            dataset.close();
        }
    }

    public <T extends Commitable> void addDataset(Class<T> recordClass, Dataset<T> dataset) {
        this.datasets.put(recordClass, dataset);
    }

    public Collection<Dataset<? extends Commitable>> getDatasets() {
        return Collections.unmodifiableCollection(this.datasets.values());
    }
}

