/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.esl.gui.editor.FormEditor;
import at.mrdevelopment.esl.gui.editor.NullEditor;
import at.mrdevelopment.esl.persistence.CustomDatasetField;
import at.mrdevelopment.esl.persistence.RecursiveDatasetField;
import at.mrdevelopment.esl.persistence.annotation.CustomField;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import at.mrdevelopment.esl.persistence.annotation.Editable;
import at.mrdevelopment.esl.persistence.annotation.IncludeDisplayables;
import at.mrdevelopment.esl.persistence.annotation.Lookup;
import at.mrdevelopment.esl.persistence.annotation.UserType;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.Column;

public class DatasetField {
    static ESLLogger logger = ESLLogger.getLogger(DatasetField.class);
    private final String internalName;
    private final Method getterMethod;
    private final Method setterMethod;

    public DatasetField(String internalName, Method getterMethod) {
        this.internalName = internalName;
        this.getterMethod = getterMethod;
        this.setterMethod = this.getSetterMethod();
    }

    public DatasetField(DatasetField datasetField) {
        this(datasetField.internalName, datasetField.getterMethod);
    }

    public String getInternalName() {
        return this.internalName;
    }

    public boolean isDisplayable() {
        return this.getterMethod.isAnnotationPresent(Displayable.class) && !this.getGetterMethod().getAnnotation(Displayable.class).hide();
    }

    public String getName() {
        Displayable displayableAnnotation = this.getterMethod.getAnnotation(Displayable.class);
        if (displayableAnnotation != null && !displayableAnnotation.name().isEmpty()) {
            return displayableAnnotation.name();
        }
        return this.internalName;
    }

    public int getDisplayWidth() {
        return this.getterMethod.getAnnotation(Displayable.class).width();
    }

    public int getOrder() {
        return this.getterMethod.isAnnotationPresent(Displayable.class) ? this.getterMethod.getAnnotation(Displayable.class).order() : 0;
    }

    public Class<?> getPersistenceType() {
        return this.getterMethod.getReturnType();
    }

    public Class<?> getType() {
        return this.getterMethod.isAnnotationPresent(UserType.class) ? this.getterMethod.getAnnotation(UserType.class).value() : this.getterMethod.getReturnType();
    }

    public Class<? extends FormEditor<?>> getEditor() {
        return this.isEditable() ? this.getterMethod.getAnnotation(Editable.class).editor() : NullEditor.class;
    }

    public boolean isEditable() {
        return this.getterMethod.isAnnotationPresent(Editable.class);
    }

    public boolean canBeNull() {
        return this.getterMethod.isAnnotationPresent(Column.class) && this.getterMethod.getAnnotation(Column.class).nullable();
    }

    public boolean isCreateOnly() {
        return this.isEditable() && this.getterMethod.getAnnotation(Editable.class).createOnly();
    }

    public boolean isConsideredInFilter() {
        return this.isDisplayable() && this.getterMethod.getAnnotation(Displayable.class).filter();
    }

    public Object getValue(Object record) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        return this.getterMethod.invoke(record, new Object[0]);
    }

    public void setValue(Object record, Object value) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.setterMethod != null) {
            this.setterMethod.invoke(record, value);
        }
    }

    public boolean hasLookup() {
        return this.getterMethod.isAnnotationPresent(Lookup.class);
    }

    public Class<?> getLookupType() {
        return this.hasLookup() ? this.getterMethod.getAnnotation(Lookup.class).lookupType() : null;
    }

    public String getLookupInternalName() {
        return this.hasLookup() ? this.getterMethod.getAnnotation(Lookup.class).lookupField() : null;
    }

    public boolean isWritable() {
        return this.setterMethod != null;
    }

    protected Method getSetterMethod() {
        try {
            return this.getterMethod.getDeclaringClass().getMethod("set" + this.internalName, this.getterMethod.getReturnType());
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    protected Method getGetterMethod() {
        return this.getterMethod;
    }

    public static Collection<DatasetField> getDatasetFields(Class<?> recordClass, List<String> customFields) throws InitializationException {
        ArrayList<DatasetField> datasetFields = new ArrayList<DatasetField>();
        for (Method method : recordClass.getMethods()) {
            DatasetField datasetField;
            if (!method.getName().startsWith("get")) continue;
            String internalName = method.getName().substring(3);
            Class<?> type = method.getReturnType();
            if (method.isAnnotationPresent(IncludeDisplayables.class)) {
                Collection<DatasetField> recursiveFields = DatasetField.getDatasetFields(type, customFields);
                for (DatasetField recursiveField : recursiveFields) {
                    RecursiveDatasetField datasetField2 = new RecursiveDatasetField(internalName, recursiveField);
                    datasetFields.add(datasetField2);
                }
                continue;
            }
            if (method.isAnnotationPresent(CustomField.class)) {
                datasetField = new DatasetField(internalName, method);
                for (String customField : customFields) {
                    CustomDatasetField customDatasetField = new CustomDatasetField(customField, datasetField);
                    datasetFields.add(customDatasetField);
                }
                continue;
            }
            datasetField = new DatasetField(internalName, method);
            datasetFields.add(datasetField);
        }
        Collections.sort(datasetFields, new Comparator<DatasetField>(){

            @Override
            public int compare(DatasetField first, DatasetField second) {
                if (first.getOrder() < second.getOrder()) {
                    return -1;
                }
                if (first.getOrder() > second.getOrder()) {
                    return 1;
                }
                return 0;
            }
        });
        return datasetFields;
    }
}

