/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import joptsimple.internal.Strings;

public class CustomFieldsDefinition {
    static ESLLogger logger = ESLLogger.getLogger(CustomFieldsDefinition.class);
    private final List<String> customFields = new ArrayList<String>();

    public CustomFieldsDefinition(String customFieldsDefinition) {
        Iterable customFields = Splitter.on((String)";").trimResults().split((CharSequence)customFieldsDefinition);
        Iterables.addAll(this.customFields, (Iterable)Iterables.filter((Iterable)customFields, (Predicate)new Predicate<String>(){

            public boolean apply(String field) {
                return CustomFieldsDefinition.this.checkCustomField(field);
            }
        }));
    }

    public CustomFieldsDefinition(File customFieldDefinitionFile) throws InitializationException {
        try {
            this.customFields.addAll(this.readCustomFields(new BufferedReader(new FileReader(customFieldDefinitionFile))));
        }
        catch (FileNotFoundException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IOException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (RuntimeException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public List<String> getCustomFields() {
        return Collections.unmodifiableList(this.customFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readCustomFields(BufferedReader reader) throws IOException {
        ArrayList<String> customFields = new ArrayList<String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#") && this.checkCustomField(line)) {
                    customFields.add(line);
                }
                line = reader.readLine();
            }
        }
        finally {
            StreamUtils.close((Reader)reader);
        }
        return customFields;
    }

    private boolean checkCustomField(String field) {
        if (Strings.isNullOrEmpty((String)field)) {
            logger.warn("Ignoring empty custom field");
            return false;
        }
        if (!field.matches("[a-z][A-Za-z0-9]*")) {
            logger.warn("Ignoring custom field '%s' with illegal characters", new Object[]{field});
            return false;
        }
        return true;
    }
}

