/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.esl.persistence.DatasetAction;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetListener;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.Identifiable;

public abstract class AbstractLazyDatasetListener<T extends Identifiable>
implements DatasetListener<T> {
    private DatasetAction action;
    private T record;

    @Override
    public void recordInsert(T record, Transaction<?> transaction) throws DatasetException {
        this.record = record;
        this.action = DatasetAction.INSERT;
    }

    @Override
    public void recordUpdate(T record, Transaction<?> transaction) throws DatasetException {
        this.record = record;
        this.action = DatasetAction.MODIFY;
    }

    @Override
    public void recordDelete(T record, Transaction<?> transaction) throws DatasetException {
        this.record = record;
        this.action = DatasetAction.DELETE;
    }

    public void apply() throws DatasetException {
        switch (this.action) {
            case DELETE: {
                this.onRecordDelete(this.record);
                break;
            }
            case INSERT: {
                this.onRecordInsert(this.record);
                break;
            }
            case MODIFY: {
                this.onRecordUpdate(this.record);
                break;
            }
        }
    }

    public abstract void onRecordInsert(T var1) throws DatasetException;

    public abstract void onRecordUpdate(T var1) throws DatasetException;

    public abstract void onRecordDelete(T var1) throws DatasetException;
}

