/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.network;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.admin.platform.NetworkProperty;
import at.mrdevelopment.toolkit.InitializationException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;

public class NetworkStatus {
    private List<NetworkProperty> networkProperties;

    public NetworkStatus() throws InitializationException {
        try {
            this.networkProperties = this.parseNetworkProperties();
        }
        catch (SocketException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (UnknownHostException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public NetworkStatus(List<NetworkProperty> networkProperties) {
        this.networkProperties = networkProperties;
    }

    private List<NetworkProperty> parseNetworkProperties() throws SocketException, UnknownHostException {
        ArrayList<NetworkProperty> properties = new ArrayList<NetworkProperty>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            NetworkProperty networkProperty = EnvironmentProperties.parseNetworkProperty(networkInterface, true, false, false);
            if (networkProperty == null) continue;
            properties.add(networkProperty);
        }
        Collections.sort(properties, new Comparator<NetworkProperty>(){

            @Override
            public int compare(NetworkProperty o1, NetworkProperty o2) {
                return o1.getInterfaceName().compareTo(o2.getInterfaceName());
            }
        });
        return properties;
    }

    public List<NetworkProperty> getNetworkProperties() {
        return Collections.unmodifiableList(this.networkProperties);
    }
}

