/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.msp;

import org.apache.commons.lang.StringUtils;

public class MSPConfiguration {
    public static final int DEFAULT_FTP_PORT = 21;
    public static final int DEFAULT_UPLOAD_INTERVAL_MINUTES = 15;
    private static final String DEFAULT_FTP_USERNAME = "anonymous";
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String path;
    private final int uploadInterval;
    private final boolean enabled;

    public MSPConfiguration() {
        this(null, 21, null, null, null, 15, false);
    }

    public MSPConfiguration(String host, int port, String username, String password, String path, int uploadIntervalInMinutes, boolean enabled) {
        this.host = host;
        this.port = port;
        this.username = StringUtils.isEmpty((String)username) ? DEFAULT_FTP_USERNAME : username;
        this.password = password;
        this.path = this.checkPath(path);
        this.uploadInterval = uploadIntervalInMinutes;
        this.enabled = enabled;
    }

    private String checkPath(String path) {
        if (path != null && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getUploadInterval() {
        return this.uploadInterval;
    }
}

