/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import at.mrdevelopment.esl.licencing.LicenseKey;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class LicenseKeyTest {
    private static final String SECRET_1 = "zfahEuhcP3PgWMhIFI7ubA==";
    private static final String SECRET_2 = "yvRSuUjgl864WnXh34u2hg==";

    @Test
    public void toStringWithSecret1() {
        Assert.assertEquals((Object)"ESL_DEMO_HJIA-AAIA-TUHV-SQHN", (Object)new LicenseKey("ESL_DEMO", 0, 1, 2014, 37).toString(SECRET_1));
        Assert.assertEquals((Object)"ESL_DEMO_HJQA-AAIA-X6G7-MBBQ", (Object)new LicenseKey("ESL_DEMO", 0, 1, 2014, 38).toString(SECRET_1));
        Assert.assertEquals((Object)"ESL_DEMO_HZIA-AAIA-UOBL-HIT3", (Object)new LicenseKey("ESL_DEMO", 0, 1, 2015, 37).toString(SECRET_1));
        Assert.assertEquals((Object)"ESL_DEMO_HJIA-AAQA-AA4E-SOJJ", (Object)new LicenseKey("ESL_DEMO", 0, 2, 2014, 37).toString(SECRET_1));
        Assert.assertEquals((Object)"ESL_DEMO_HJIA-AAIB-TMVB-25CH", (Object)new LicenseKey("ESL_DEMO", 1, 1, 2014, 37).toString(SECRET_1));
        Assert.assertEquals((Object)"ESL_RETAIL_MINI_HJIA-AAIB-7GJQ-UXI4", (Object)new LicenseKey("ESL_RETAIL_MINI", 1, 1, 2014, 37).toString(SECRET_1));
        Assert.assertEquals((Object)"UPG_AP10_HJIA-AAYA-VZKT-WXLS", (Object)new LicenseKey("UPG_AP10", 0, 3, 2014, 37).toString(SECRET_1));
    }

    @Test
    public void toStringWithSecret2() {
        Assert.assertEquals((Object)"ESL_DEMO_HJIA-AAIA-7RCH-67GN", (Object)new LicenseKey("ESL_DEMO", 0, 1, 2014, 37).toString(SECRET_2));
        Assert.assertEquals((Object)"ESL_DEMO_HJQA-AAIA-MQXR-NDZL", (Object)new LicenseKey("ESL_DEMO", 0, 1, 2014, 38).toString(SECRET_2));
        Assert.assertEquals((Object)"ESL_DEMO_HZIA-AAIA-EEWR-IRXX", (Object)new LicenseKey("ESL_DEMO", 0, 1, 2015, 37).toString(SECRET_2));
        Assert.assertEquals((Object)"ESL_DEMO_HJIA-AAQA-ZA7C-AJN6", (Object)new LicenseKey("ESL_DEMO", 0, 2, 2014, 37).toString(SECRET_2));
        Assert.assertEquals((Object)"ESL_DEMO_HJIA-AAIB-QHIH-XTEB", (Object)new LicenseKey("ESL_DEMO", 1, 1, 2014, 37).toString(SECRET_2));
        Assert.assertEquals((Object)"ESL_DEMO_HPYA-AAIA-V7BG-7IR2", (Object)new LicenseKey("ESL_DEMO", 0, 1, 2014, 127).toString(SECRET_2));
        Assert.assertEquals((Object)"ESL_DEMO_HAAA-AAIA-GZDB-URMF", (Object)new LicenseKey("ESL_DEMO", 0, 1, 2014, 128).toString(SECRET_2));
        Assert.assertEquals((Object)"ESL_RETAIL_MINI_HJIA-AAIB-FHZB-WMLX", (Object)new LicenseKey("ESL_RETAIL_MINI", 1, 1, 2014, 37).toString(SECRET_2));
    }

    @Test
    public void testRealKey1() {
        LicenseKey key = LicenseKey.fromString("DEV_UNLIMITED_HTAA-A6IA-PNNH-VTDH");
        Assert.assertEquals((long)121L, (long)key.getSerialNumber());
        Assert.assertEquals((long)2015L, (long)key.getYear());
        Assert.assertEquals((long)12L, (long)key.getWeek());
        Assert.assertEquals((long)0L, (long)key.getCustomerId());
        Assert.assertEquals((Object)"DEV_UNLIMITED_HTAA-A6IA-PNNH-VTDH", (Object)new LicenseKey("DEV_UNLIMITED", 0, 121, 2015, 12).toString("d2Nl6oQ3czq0g1R0aNkwK+NxQG1I+wQf"));
    }

    @Test
    public void testRealKey2() {
        LicenseKey key = LicenseKey.fromString("DEV_UNLIMITED_HTIA-BUYA-JMUT-DMQA");
        Assert.assertEquals((long)211L, (long)key.getSerialNumber());
        Assert.assertEquals((long)2015L, (long)key.getYear());
        Assert.assertEquals((long)13L, (long)key.getWeek());
        Assert.assertEquals((long)0L, (long)key.getCustomerId());
        Assert.assertEquals((Object)"DEV_UNLIMITED_HTIA-BUYA-JMUT-DMQA", (Object)new LicenseKey("DEV_UNLIMITED", 0, 211, 2015, 13).toString("fnpv2dHb691e9Jfp6+h2L3Bw34phRFsy"));
    }

    @Test
    public void testCustomerIdCornerCases() {
        ArrayList cornerCases = Lists.newArrayList((Object[])new Integer[]{0, 1, 127, 128, 255});
        Iterator i$ = cornerCases.iterator();
        while (i$.hasNext()) {
            int customerId = (Integer)i$.next();
            String key = new LicenseKey("DEMO", customerId, 0, 2015, 1).toString(SECRET_1);
            Assert.assertEquals((long)customerId, (long)LicenseKey.fromString(key).getCustomerId());
        }
    }

    @Test
    public void testSerialNumberCornerCases() {
        ArrayList cornerCases = Lists.newArrayList((Object[])new Integer[]{0, 1, 127, 128, 255, 256, 65535, 65536, 1048575});
        Iterator i$ = cornerCases.iterator();
        while (i$.hasNext()) {
            int serialNumber = (Integer)i$.next();
            String key = new LicenseKey("DEMO", 0, serialNumber, 2015, 1).toString(SECRET_1);
            Assert.assertEquals((long)serialNumber, (long)LicenseKey.fromString(key).getSerialNumber());
        }
    }

    @Test
    public void testYearCornerCases() {
        ArrayList cornerCases = Lists.newArrayList((Object[])new Integer[]{2000, 2063});
        Iterator i$ = cornerCases.iterator();
        while (i$.hasNext()) {
            int year = (Integer)i$.next();
            String key = new LicenseKey("DEMO", 0, 0, year, 1).toString(SECRET_1);
            Assert.assertEquals((long)year, (long)LicenseKey.fromString(key).getYear());
        }
    }

    @Test
    public void testWeekCornerCases() {
        ArrayList cornerCases = Lists.newArrayList((Object[])new Integer[]{0, 1, 52, 53, 63});
        Iterator i$ = cornerCases.iterator();
        while (i$.hasNext()) {
            int week = (Integer)i$.next();
            String key = new LicenseKey("DEMO", 0, 0, 2015, week).toString(SECRET_1);
            Assert.assertEquals((long)week, (long)LicenseKey.fromString(key).getWeek());
        }
    }

    @Test
    public void isValidSecret() {
        Assert.assertTrue((boolean)LicenseKey.isValid("ESL_DEMO_HJIA-AAIA-TUHV-SQHN", SECRET_1));
        Assert.assertFalse((boolean)LicenseKey.isValid("ESL_DEMO_HJIA-AAIA-7RCH-67GN", SECRET_1));
        Assert.assertTrue((boolean)LicenseKey.isValid("ESL_DEMO_HJIA-AAIA-7RCH-67GN", SECRET_2));
        Assert.assertFalse((boolean)LicenseKey.isValid("ESL_DEMO_HJIA-AAIA-TUHV-SQHN", SECRET_2));
        Assert.assertTrue((boolean)LicenseKey.isValid("ESL_DEMO_HPYA-AAIA-V7BG-7IR2", SECRET_2));
        Assert.assertTrue((boolean)LicenseKey.isValid("ESL_DEMO_HAAA-AAIA-GZDB-URMF", SECRET_2));
    }

    @Test
    public void fromString() {
        LicenseKey activationKey = LicenseKey.fromString("ESL_DEMO_HJIA-AAIA-TUHV-SQHN");
        Assert.assertEquals((Object)"ESL_DEMO", (Object)activationKey.getProduct());
        Assert.assertEquals((long)0L, (long)activationKey.getCustomerId());
        Assert.assertEquals((long)1L, (long)activationKey.getSerialNumber());
        Assert.assertEquals((long)2014L, (long)activationKey.getYear());
        Assert.assertEquals((long)37L, (long)activationKey.getWeek());
    }
}

