/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import java.util.Arrays;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class LicenseKey {
    private static final int HASH_LENGTH = 12;
    private static final int YEAR_OFFSET = 2000;
    private final String product;
    private final int customerId;
    private final int serialNumber;
    private final int year;
    private final int week;

    public static boolean isValid(String licenseKey, String secret) {
        return LicenseKey.fromString(licenseKey).toString(secret).equals(licenseKey);
    }

    public LicenseKey(String product, int customerId, int serialNumber, DateTime now) {
        this(product, customerId, serialNumber, now.getYear(), now.getWeekOfWeekyear());
    }

    public LicenseKey(String product, int customerId, int serialNumber, int year, int week) {
        this.product = product;
        this.customerId = customerId;
        this.serialNumber = serialNumber;
        this.year = year;
        this.week = week;
    }

    public String getProduct() {
        return this.product;
    }

    public int getCustomerId() {
        return this.customerId;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getYear() {
        return this.year;
    }

    public int getWeek() {
        return this.week;
    }

    private byte[] getKeyId() {
        byte[] bytes = new byte[]{(byte)((this.year - 2000 & 0x3F) << 2 | this.week >> 4 & 3), (byte)((this.week & 0xF) << 4 | this.serialNumber >> 16 & 0xF), (byte)(this.serialNumber >> 8 & 0xFF), (byte)(this.serialNumber >> 0 & 0xFF), (byte)(this.customerId & 0xFF)};
        return bytes;
    }

    private String getKeyIdBase32() {
        return new Base32().encodeToString(this.getKeyId());
    }

    private byte[] getHash(String secret) {
        return Arrays.copyOf(DigestUtils.sha256((String)(this.product + this.getKeyIdBase32() + secret)), 12);
    }

    private String getHashBase32(String secret) {
        return new Base32().encodeToString(this.getHash(secret));
    }

    public static LicenseKey fromString(String licenseKey) {
        int index = StringUtils.lastIndexOf((String)licenseKey, (String)"_");
        String product = licenseKey.substring(0, index);
        String keyIdBase32 = licenseKey.substring(index + 1, index + 5) + licenseKey.substring(index + 6, index + 10);
        byte[] keyId = new Base32().decode(keyIdBase32);
        int year = (keyId[0] >> 2 & 0x3F) + 2000;
        int week = (keyId[0] & 3) << 4 | keyId[1] >> 4 & 0xF;
        int serialNumber = (keyId[1] & 0xF) << 16 | (keyId[2] & 0xFF) << 8 | keyId[3] & 0xFF;
        int customerId = keyId[4] & 0xFF;
        return new LicenseKey(product, customerId, serialNumber, year, week);
    }

    public String toString(String secret) {
        String keyIdBase32 = this.getKeyIdBase32();
        String hash = this.getHashBase32(secret);
        StringBuilder builder = new StringBuilder();
        builder.append(this.product);
        builder.append("_");
        builder.append(keyIdBase32.substring(0, 4));
        builder.append("-");
        builder.append(keyIdBase32.substring(4, 8));
        builder.append("-");
        builder.append(hash.substring(0, 4));
        builder.append("-");
        builder.append(hash.substring(4, 8));
        return builder.toString();
    }
}

