/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import at.mrdevelopment.esl.type.Licence;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import joptsimple.internal.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LicenceXMLSerializer
implements XMLSerializer<Licence> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Licence licence) {
        Document document = this.xmlToolkit.newDocument();
        Element element = document.createElement("labelLicence");
        Element licenceKey = document.createElement("licenceKey");
        licenceKey.setTextContent(licence.getLicenceKey());
        element.appendChild(licenceKey);
        if (!Strings.isNullOrEmpty((String)licence.getContent())) {
            Element content = document.createElement("content");
            content.setTextContent(licence.getContent());
            element.appendChild(content);
        }
        Element comment = document.createElement("comment");
        comment.setTextContent(licence.getComment());
        element.appendChild(comment);
        document.appendChild(element);
        return document;
    }

    public Licence parseXML(InputStream xmlInputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
        return this.parseLicenceFromXML(root);
    }

    private Licence parseLicenceFromXML(Element element) throws SerializeException {
        NodeList licenceKeyList = element.getElementsByTagName("licenceKey");
        NodeList commentList = element.getElementsByTagName("comment");
        String licenceKey = licenceKeyList.item(0).getTextContent().trim();
        String comment = commentList.item(0).getTextContent().trim();
        return new Licence(comment, licenceKey);
    }
}

