/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.toolkit.InitializationException;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.digest.DigestUtils;

public class InstallationId {
    private static final int LENGTH = 10;
    private final byte[] id;

    public static InstallationId getId() throws InitializationException {
        EnvironmentProperties properties = new EnvironmentProperties(false);
        String macAddress = properties.getMacAddress();
        return new InstallationId(macAddress);
    }

    public static InstallationId fromMacAddress(String macAddress) {
        return new InstallationId(macAddress);
    }

    private InstallationId(String macAddress) {
        this.id = Arrays.copyOf(DigestUtils.sha256((String)macAddress.toString()), 10);
    }

    public String toBase32() {
        return new Base32().encodeToString(this.id);
    }

    public String toString() {
        String base32 = this.toBase32();
        StringBuilder builder = new StringBuilder();
        builder.append(base32.substring(0, 4));
        builder.append("-");
        builder.append(base32.substring(4, 8));
        builder.append("-");
        builder.append(base32.substring(8, 12));
        builder.append("-");
        builder.append(base32.substring(12, 16));
        return builder.toString();
    }
}

