/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.licencing.FeatureMode;
import at.mrdevelopment.esl.licencing.LicenseReader;
import at.mrdevelopment.esl.type.LicenceContent;
import at.mrdevelopment.esl.type.LicencedFeature;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.Range;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;

public class FeatureUnlock {
    static ESLLogger logger = ESLLogger.getLogger(FeatureUnlock.class);
    private final LicenseReader licenseReader;
    private final List<List<Range<Address>>> licensedLabels = new ArrayList<List<Range<Address>>>();
    private final Set<Integer> upgradeSerialNumbers = new HashSet<Integer>();
    private FeatureMode mode;
    private int customerId;
    private String customer;
    private boolean development;
    private int additionalAccessPointsAllowed;
    private int additionalLabelsAllowed;
    private int additionalArticlesAllowed;
    private boolean unlockColors;
    private boolean unlockSiteSurvey;

    public FeatureUnlock(LicenseReader licenseReader) {
        this.licenseReader = licenseReader;
        this.reset();
    }

    public synchronized Map<String, String> getAdditionalServiceStatusEntries() {
        return this.licenseReader.getAdditionalServiceStatusEntries();
    }

    public synchronized String getDefaultSystemSerial() {
        return this.licenseReader.getDefaultSystemSerial();
    }

    public synchronized void processLicense(String licenseKey) throws SerializeException {
        LicenceContent licenseContent = this.licenseReader.processLicense(licenseKey);
        this.applyLabelRanges(licenseContent.getLabelRanges());
        this.applyFeatures(licenseContent.getFeatures());
    }

    private synchronized void applyLabelRanges(List<Range<Address>> labelRanges) {
        if (!labelRanges.isEmpty()) {
            logger.info("Applying %d label ranges from license", new Object[]{labelRanges.size()});
            this.licensedLabels.add(labelRanges);
        }
    }

    public synchronized void reset() {
        this.licensedLabels.clear();
        this.upgradeSerialNumbers.clear();
        this.mode = FeatureMode.NONE;
        this.customerId = 0;
        this.customer = null;
        this.development = false;
        this.additionalAccessPointsAllowed = 0;
        this.additionalLabelsAllowed = 0;
        this.additionalArticlesAllowed = 0;
        this.unlockColors = false;
        this.unlockSiteSurvey = false;
    }

    public synchronized FeatureMode getMode() {
        return this.mode;
    }

    public synchronized int getCustomerId() {
        return this.customerId;
    }

    public synchronized boolean hasCustomer() {
        return this.customer != null;
    }

    public synchronized String getCustomer() {
        return this.customer != null ? this.customer : "Unknown";
    }

    public synchronized boolean isLicensed() {
        return this.mode != FeatureMode.NONE;
    }

    public synchronized boolean isDemoMode() {
        return this.mode == FeatureMode.DEMO;
    }

    public synchronized boolean isProductive() {
        return this.mode != FeatureMode.NONE && this.mode != FeatureMode.DEVELOPMENT && !this.development;
    }

    public synchronized boolean isExpired(DateTime now) {
        return false;
    }

    public synchronized int getMaxIntegrationLevel() {
        return this.mode.getMaxIntegrationLevel();
    }

    public synchronized int getMaxAccessPointsAllowed() {
        return this.mode.getMaxAccessPointsAllowed() + this.additionalAccessPointsAllowed;
    }

    public synchronized int getMaxLabelsAllowed() {
        return this.mode.getMaxLabelsAllowed() + this.additionalLabelsAllowed;
    }

    public synchronized int getMaxArticlesAllowed() {
        return this.mode.getMaxArticlesAllowed() + this.additionalArticlesAllowed;
    }

    public synchronized boolean isColorsAllowed() {
        return this.unlockColors || this.mode.isColorsAllowed();
    }

    public synchronized boolean isSiteSurveyAllowed() {
        return this.unlockSiteSurvey;
    }

    public synchronized boolean isThinAccessPointModeAllowed() {
        return this.mode.isThinAccessPointModeAllowed();
    }

    public synchronized boolean isThickAccessPointModeAllowed() {
        return this.mode.isThickAccessPointModeAllowed();
    }

    public synchronized boolean isUnrestrictedSyncAllowed() {
        return this.mode.isUnrestrictedSyncAllowed();
    }

    public synchronized boolean isRegistrationWithLabelIdAllowed() {
        return this.mode.isRegistrationWithLabelIdAllowed();
    }

    public synchronized boolean isAlternateRegistrationCodeRequired() {
        return this.mode.isAlternateRegistrationCodeRequired();
    }

    public synchronized boolean isUnencryptedCommunicationAllowed() {
        return this.mode.isUnencryptedCommunicationAllowed();
    }

    public synchronized boolean isPluginsAllowed() {
        return this.mode.isPluginsAllowed();
    }

    public synchronized boolean isRenderingEngineAvailable() {
        return this.mode.isRenderingEngineAvailable();
    }

    public synchronized boolean isLabelTypeAllowed(LabelType labelType) {
        return this.mode.isLabelTypeAllowed(labelType);
    }

    public synchronized boolean isLabelFromLegacyBlacklistAllowed() {
        return this.mode.isLabelFromLegacyBlacklistAllowed();
    }

    public boolean isLabelOnLegacyBlacklist(Address address) {
        long hardwareAddress = address.getHardwareAddress();
        if (hardwareAddress >= 0xB1001000L && hardwareAddress <= 2969632766L) {
            return true;
        }
        if (hardwareAddress >= 0xB2000000L && hardwareAddress <= 3003121662L) {
            return true;
        }
        if (hardwareAddress >= 3003125760L && hardwareAddress <= 3003252734L) {
            return true;
        }
        if (hardwareAddress >= 0xC1001000L && hardwareAddress <= 3238133758L) {
            return true;
        }
        return hardwareAddress >= 0xD1001000L && hardwareAddress <= 3506503678L;
    }

    public synchronized boolean isLabelAllowed(Address address, LabelType labelType) {
        if (!this.isLabelTypeAllowed(labelType)) {
            logger.info("Label type %s is not allowed (%s)", new Object[]{labelType.toString(), address.toString()});
            return false;
        }
        if (this.isLabelOnLegacyBlacklist(address)) {
            if (this.isLabelFromLegacyBlacklistAllowed()) {
                return this.isLabelWithinAllowedRanges(address);
            }
            logger.info("Label %s is blacklisted", new Object[]{address.toString()});
            return false;
        }
        return true;
    }

    public synchronized boolean isAccessPointTypeAllowed(AccessPointType accessPointType) {
        return this.mode.isAccessPointTypeAllowed(accessPointType);
    }

    private synchronized boolean isLabelWithinAllowedRanges(Address address) {
        for (List<Range<Address>> labelRanges : this.licensedLabels) {
            for (Range<Address> labelRange : labelRanges) {
                if (!labelRange.contains((Comparable)address)) continue;
                return true;
            }
        }
        logger.info("Label %s is not licensed", new Object[]{address.toString()});
        return false;
    }

    private void applyFeatures(Set<LicencedFeature> features) {
        Map<String, LicencedFeature> featuresMap = this.getFeaturesMap(features);
        LicencedFeature customer = featuresMap.get("customer");
        LicencedFeature installationLock = featuresMap.get("installation-lock");
        if (customer != null) {
            logger.info("License is issued for '%s'", new Object[]{customer.getString()});
        }
        if (features.size() > 0 && this.isValidForInstallation(installationLock)) {
            this.applyBasicLicense(featuresMap);
            this.applyAdditionalFeatures(featuresMap);
        }
    }

    private void applyBasicLicense(Map<String, LicencedFeature> featuresMap) {
        LicencedFeature modeFeature = featuresMap.get("mode");
        if (modeFeature != null) {
            LicencedFeature customerIdFeature = featuresMap.get("customer-id");
            LicencedFeature customerFeature = featuresMap.get("customer");
            LicencedFeature develomentFeature = featuresMap.get("development");
            FeatureMode mode = FeatureMode.fromString(modeFeature.getValue().toUpperCase());
            logger.info("Set basic license feature mode to %s", new Object[]{mode});
            this.mode = mode;
            this.customerId = customerIdFeature != null ? customerIdFeature.getInteger() : 0;
            this.customer = customerFeature != null ? customerFeature.getString() : null;
            this.development = develomentFeature != null ? develomentFeature.getBoolean() : false;
        }
    }

    private void applyAdditionalFeatures(Map<String, LicencedFeature> featuresMap) {
        LicencedFeature serialNumberFeature = featuresMap.get("serial-number");
        if (serialNumberFeature != null) {
            int serialNumber = serialNumberFeature.getInteger();
            logger.info("License serial number is %d", new Object[]{serialNumber});
            if (this.upgradeSerialNumbers.contains(serialNumber)) {
                logger.warn("Duplicate license serial number %d", new Object[]{serialNumber});
                return;
            }
            this.upgradeSerialNumbers.add(serialNumber);
        } else {
            logger.info("License has no serial number");
        }
        LicencedFeature additionalAccessPoints = featuresMap.get("add-allowed-access-points");
        LicencedFeature additionalLabels = featuresMap.get("add-allowed-labels");
        LicencedFeature additionalArticles = featuresMap.get("add-allowed-articles");
        LicencedFeature unlockColorsFeature = featuresMap.get("unlock-colors");
        LicencedFeature unockSiteSurveyFeature = featuresMap.get("unlock-site-survey");
        if (additionalAccessPoints != null) {
            logger.info("Unlocking additional %d access points", new Object[]{additionalAccessPoints.getInteger()});
            this.additionalAccessPointsAllowed += additionalAccessPoints.getInteger();
        }
        if (additionalLabels != null) {
            logger.info("Unlocking additional %d labels", new Object[]{additionalLabels.getInteger()});
            this.additionalLabelsAllowed += additionalLabels.getInteger();
        }
        if (additionalArticles != null) {
            logger.info("Unlocking additional %d articles", new Object[]{additionalArticles.getInteger()});
            this.additionalArticlesAllowed += additionalArticles.getInteger();
        }
        if (unlockColorsFeature != null && unlockColorsFeature.getBoolean()) {
            logger.info("Unlocking colors");
            this.unlockColors = true;
        }
        if (unockSiteSurveyFeature != null && unockSiteSurveyFeature.getBoolean()) {
            logger.info("Unlocking site survey");
            this.unlockSiteSurvey = true;
        }
    }

    private boolean isValidForInstallation(LicencedFeature installationLock) {
        if (installationLock == null) {
            logger.info("License is not system-locked");
            return true;
        }
        String lockedSystemSerial = installationLock.getString();
        for (String systemSerial : this.licenseReader.getAllSystemSerials()) {
            if (!lockedSystemSerial.equals(systemSerial)) continue;
            logger.info("System-lock is valid for system serial %s", new Object[]{lockedSystemSerial});
            return true;
        }
        logger.info("License is locked to system serial %s", new Object[]{lockedSystemSerial});
        return false;
    }

    private Map<String, LicencedFeature> getFeaturesMap(Set<LicencedFeature> features) {
        logger.debug("Applying %d new features", new Object[]{features.size()});
        HashMap<String, LicencedFeature> featuresMap = new HashMap<String, LicencedFeature>();
        for (LicencedFeature feature : features) {
            logger.debug("Loading license feature %s", new Object[]{feature});
            featuresMap.put(feature.getKey(), feature);
        }
        return featuresMap;
    }
}

