/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import at.mrdevelopment.esl.licencing.DecryptInputStream;
import at.mrdevelopment.esl.licencing.LicenseReader;
import at.mrdevelopment.esl.type.LicenceContent;
import at.mrdevelopment.esl.type.LicencedFeature;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Range;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.licensing.SystemSerial;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.openssl.PEMReader;

public class DefaultLicenseReader
implements LicenseReader {
    static ESLLogger logger = ESLLogger.getLogger(DefaultLicenseReader.class);
    public static final String PUBLIC_KEY = "/licence/licence.public";
    private final PublicKey key;
    private final SystemSerial defaultSystemSerial;
    private final List<SystemSerial> allSystemSerials;

    public DefaultLicenseReader() throws InitializationException {
        this((String)null);
    }

    public DefaultLicenseReader(String preferredInterface) throws InitializationException {
        this(new SystemSerial(preferredInterface));
    }

    public DefaultLicenseReader(SystemSerial.SystemType type, int deviceId) throws InitializationException {
        this(new SystemSerial(type, deviceId));
    }

    private DefaultLicenseReader(SystemSerial defaultSystemSerial) throws InitializationException {
        logger.info("Using %s", new Object[]{defaultSystemSerial.getSystemSeed()});
        logger.info("Default system serial is %s", new Object[]{defaultSystemSerial.getSystemSerial()});
        this.key = this.readPublicKey();
        this.defaultSystemSerial = defaultSystemSerial;
        this.allSystemSerials = defaultSystemSerial.getAllSystemSerials();
    }

    @Override
    public void reset() {
    }

    @Override
    public String getDefaultSystemSerial() {
        return this.defaultSystemSerial.getSystemSerial();
    }

    @Override
    public Iterable<String> getAllSystemSerials() {
        return Iterables.transform(this.allSystemSerials, (Function)new Function<SystemSerial, String>(){

            public String apply(SystemSerial systemSerial) {
                return systemSerial.getSystemSerial();
            }
        });
    }

    @Override
    public boolean isValidLicense(String licenseKey) {
        try {
            this.processLicense(licenseKey);
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LicenceContent processLicense(String licenseKey) throws SerializeException {
        LicenceContent licenceContent;
        ReaderInputStream inputStream = null;
        try {
            inputStream = new ReaderInputStream((Reader)new BufferedReader(new StringReader(licenseKey)));
            licenceContent = this.readFromStream((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.close(inputStream);
            throw throwable;
        }
        StreamUtils.close((InputStream)inputStream);
        return licenceContent;
    }

    private LicenceContent readFromStream(InputStream licenseInputStream) throws SerializeException {
        try {
            DecryptInputStream inputStream = new DecryptInputStream(licenseInputStream, this.key);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            return this.readLicenseContent(reader);
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    protected LicenceContent readLicenseContent(BufferedReader reader) throws SerializeException {
        try {
            ArrayList<Range<Address>> labelRanges = new ArrayList<Range<Address>>();
            HashSet<LicencedFeature> features = new HashSet<LicencedFeature>();
            String line = reader.readLine();
            while (line != null) {
                String[] tokens = StringUtils.split((String)line, (String)":");
                if (tokens != null && tokens.length == 2) {
                    String lineIdentifier = tokens[0];
                    String lineContent = tokens[1];
                    if (lineIdentifier.equals("l")) {
                        labelRanges.add(this.readRangeLine(lineContent));
                    } else if (lineIdentifier.equals("f")) {
                        LicencedFeature feature = this.readFeature(lineContent);
                        features.add(feature);
                    }
                }
                line = reader.readLine();
            }
            return new LicenceContent(labelRanges, features);
        }
        catch (IOException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private Range<Address> readRangeLine(String content) throws SerializeException {
        String[] tokens = StringUtils.split((String)content, (String)";");
        try {
            if (tokens == null) {
                throw new SerializeException("Invalid label file format", new Object[0]);
            }
            if (tokens.length == 1) {
                Address address = Address.fromString(tokens[0]);
                return new Range((Comparable)address, (Comparable)address);
            }
            if (tokens.length == 2) {
                Address from = Address.fromString(tokens[0]);
                Address to = Address.fromString(tokens[1]);
                return new Range((Comparable)from, (Comparable)to);
            }
            throw new SerializeException("Invalid label file format", new Object[0]);
        }
        catch (NumberFormatException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private LicencedFeature readFeature(String content) throws SerializeException {
        String[] tokens = StringUtils.split((String)content, (String)"=");
        try {
            if (tokens == null) {
                throw new SerializeException("Invalid label file format", new Object[0]);
            }
            if (tokens.length == 1) {
                String key = tokens[0];
                return new LicencedFeature(key);
            }
            String key = tokens[0];
            String value = content.substring(content.indexOf("=") + 1);
            return new LicencedFeature(key, value);
        }
        catch (NumberFormatException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey readPublicKey() throws InitializationException {
        RSAPublicKey rSAPublicKey;
        InputStream inputStream = DefaultLicenseReader.class.getResourceAsStream(PUBLIC_KEY);
        PEMReader keyReader = new PEMReader((Reader)new InputStreamReader(inputStream));
        try {
            rSAPublicKey = (RSAPublicKey)keyReader.readObject();
        }
        catch (Throwable throwable) {
            try {
                keyReader.close();
                throw throwable;
            }
            catch (Exception exc) {
                throw new InitializationException((Throwable)exc, "Failed to load licence decryption key", new Object[0]);
            }
        }
        keyReader.close();
        return rSAPublicKey;
    }

    @Override
    public Map<String, String> getAdditionalServiceStatusEntries() {
        return Collections.emptyMap();
    }
}

