/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import at.mrdevelopment.esl.licencing.DecryptInputStream;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.input.ReaderInputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.junit.Before;
import org.junit.Test;

public class DecryptInputStreamTest {
    private static final String PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----\nMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCzXJvCGZAGJiGhwz/WfeEg47HR\n5cWrIHT6JRt6v5om/U9w5jFCKTeFi5GrHT3qOZOjHffiTIYWWi1cK2SFkSbvCTwi\n/VdDDwdP3e0Pb1WH6BOaa5ODxm/L8bls2M1JfIVgZiQjlvIIvuXIGOmpIYym9Hr2\nzOVRKyA0VUkacZUmIQIDAQAB\n-----END PUBLIC KEY-----";
    private static final String VALID_SESSION_KEY_LENGTH_128 = "AAAAgJVgxQ+7+H5CgXXvv8LdiTvYS84VHCo290nZP/WsW3cGnNJhEnrkamX6aSFo2f4NJkI0ZqafHKh1EcAs2uEfT/5bQ+RcJR3jlXRfQprEWHC/Srn7dfv5qwe5E1FOOID5EF+JZul2ESie41Kct1xn+erkjs/5bEWUfaGOsqE+bY5j34LB7aQzxlvtRJf3hqZJwyxxwCfN8c/ybY2jMIzUg+Q=";
    private static final String INVALID_SESSION_KEY_LENGTH_129 = "AAAAgQVgxQ+7+H5CgXXvv8LdiTvYS84VHCo290nZP/WsW3cGnNJhEnrkamX6aSFo2f4NJkI0ZqafHKh1EcAs2uEfT/5bQ+RcJR3jlXRfQprEWHC/Srn7dfv5qwe5E1FOOID5EF+JZul2ESie41Kct1xn+erkjs/5bEWUfaGOsqE+bY5j34LB7aQzxlvtRJf3hqZJwyxxwCfN8c/ybY2jMIzUg+Q=";
    private static final String INVALID_SESSION_KEY_LENGTH_127 = "AAAAfwVgxQ+7+H5CgXXvv8LdiTvYS84VHCo290nZP/WsW3cGnNJhEnrkamX6aSFo2f4NJkI0ZqafHKh1EcAs2uEfT/5bQ+RcJR3jlXRfQprEWHC/Srn7dfv5qwe5E1FOOID5EF+JZul2ESie41Kct1xn+erkjs/5bEWUfaGOsqE+bY5j34LB7aQzxlvtRJf3hqZJwyxxwCfN8c/ybY2jMIzUg+Q=";
    private Key publicKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMReader keyReader = new PEMReader((Reader)new StringReader(PUBLIC_KEY));
        try {
            this.publicKey = (RSAPublicKey)keyReader.readObject();
        }
        finally {
            keyReader.close();
        }
    }

    @Test
    public void testDecryptStreamInitializationWithKeyOfSize128() throws SerializeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IOException {
        ReaderInputStream inputStream = new ReaderInputStream((Reader)new StringReader(VALID_SESSION_KEY_LENGTH_128));
        DecryptInputStream decryptInputStream = new DecryptInputStream((InputStream)inputStream, this.publicKey);
        decryptInputStream.close();
    }

    @Test(expected=InvalidKeyException.class)
    public void testDecryptStreamInitializationWithKeyOfSize129() throws SerializeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IOException {
        ReaderInputStream inputStream = new ReaderInputStream((Reader)new StringReader(INVALID_SESSION_KEY_LENGTH_129));
        DecryptInputStream decryptInputStream = new DecryptInputStream((InputStream)inputStream, this.publicKey);
        decryptInputStream.close();
    }

    @Test(expected=InvalidKeyException.class)
    public void testDecryptStreamInitializationWithKeyOfSize127() throws SerializeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IOException {
        ReaderInputStream inputStream = new ReaderInputStream((Reader)new StringReader(INVALID_SESSION_KEY_LENGTH_127));
        DecryptInputStream decryptInputStream = new DecryptInputStream((InputStream)inputStream, this.publicKey);
        decryptInputStream.close();
    }
}

